--
-- Table structure for table `student_types`
--
CREATE TABLE `student_types` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `type` varchar(120) NOT NULL,
  `note` text,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `visitor_purposes`
--

CREATE TABLE `visitor_purposes` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `purpose` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `phone_call_logs`
--

CREATE TABLE `phone_call_logs` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `call_type` varchar(120) NOT NULL,
  `name` varchar(120) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `call_duration` varchar(50) DEFAULT NULL,
  `call_date` date DEFAULT NULL,
  `next_follow_up` date DEFAULT NULL,
  `note` text,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `postal_dispatches`
--
CREATE TABLE `postal_dispatches` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `to_title` varchar(120) DEFAULT NULL,
  `reference` varchar(120) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `from_title` varchar(120) DEFAULT NULL,
  `dispatch_date` date DEFAULT NULL,
  `attachment` varchar(120) DEFAULT NULL,
  `note` text,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `postal_receives`
--
CREATE TABLE `postal_receives` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `from_title` varchar(120) DEFAULT NULL,
  `reference` varchar(120) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `receive_date` date DEFAULT NULL,
  `to_title` varchar(120) NOT NULL,
  `attachment` varchar(120) DEFAULT NULL,
  `note` text,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `admit_card_settings`
--
CREATE TABLE `admit_card_settings` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `border_color` varchar(20) DEFAULT NULL,
  `top_bg` varchar(20) DEFAULT NULL,
  `bottom_bg` varchar(20) DEFAULT NULL,
  `school_logo` varchar(120) DEFAULT NULL,
  `school_name` varchar(120) DEFAULT NULL,
  `school_name_font_size` varchar(20) DEFAULT NULL,
  `school_name_color` varchar(20) DEFAULT NULL,
  `school_address` varchar(255) DEFAULT NULL,
  `school_address_color` varchar(20) DEFAULT NULL,
  `admit_font_size` varchar(20) DEFAULT NULL,
  `admit_color` varchar(20) DEFAULT NULL,
  `admit_bg` varchar(20) DEFAULT NULL,
  `title_font_size` varchar(20) DEFAULT NULL,
  `title_color` varchar(20) DEFAULT NULL,
  `value_font_size` varchar(20) DEFAULT NULL,
  `value_color` varchar(20) DEFAULT NULL,
  `exam_font_size` varchar(20) DEFAULT NULL,
  `exam_color` varchar(20) DEFAULT NULL,
  `subject_font_size` varchar(20) DEFAULT NULL,
  `subject_color` varchar(20) DEFAULT NULL,
  `bottom_text` varchar(100) DEFAULT NULL,
  `bottom_text_color` varchar(20) DEFAULT NULL,
  `bottom_text_align` varchar(50) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `id_card_settings`
--
CREATE TABLE `id_card_settings` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `border_color` varchar(20) DEFAULT NULL,
  `top_bg` varchar(20) DEFAULT NULL,
  `bottom_bg` varchar(20) DEFAULT NULL,
  `school_logo` varchar(120) DEFAULT NULL,
  `school_name` varchar(120) DEFAULT NULL,
  `school_name_font_size` varchar(20) DEFAULT NULL,
  `school_name_color` varchar(20) DEFAULT NULL,
  `school_address` varchar(255) DEFAULT NULL,
  `school_address_color` varchar(20) DEFAULT NULL,
  `id_no_font_size` varchar(20) DEFAULT NULL,
  `id_no_color` varchar(20) DEFAULT NULL,
  `id_no_bg` varchar(20) DEFAULT NULL,
  `title_font_size` varchar(20) DEFAULT NULL,
  `title_color` varchar(20) DEFAULT NULL,
  `value_font_size` varchar(20) DEFAULT NULL,
  `value_color` varchar(20) DEFAULT NULL,
  `bottom_text` varchar(100) DEFAULT NULL,
  `bottom_text_color` varchar(20) DEFAULT NULL,
  `bottom_text_align` varchar(50) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


--
-- Table structure for table `leave_types`
--
CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `type` varchar(120) NOT NULL,
  `total_leave` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `leave_applications`
--
CREATE TABLE `leave_applications` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `academic_year_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `type_id` int(11) NOT NULL,
  `leave_from` date NOT NULL,
  `leave_to` date NOT NULL,
  `leave_day` int(11) NOT NULL,
  `leave_reason` text,
  `leave_note` text,
  `leave_date` datetime NOT NULL,
  `leave_status` tinyint(1) NOT NULL COMMENT '[0 = new ,1 = waiting, 2 = approved, 3 = decline]',
  `attachment` varchar(120) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


--
-- Table structure for table `email_settings`
--
CREATE TABLE `email_settings` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `mail_protocol` varchar(50) NOT NULL,
  `smtp_host` varchar(100) NOT NULL,
  `smtp_port` varchar(20) NOT NULL,
  `smtp_timeout` tinyint(1) NOT NULL,
  `smtp_user` varchar(100) NOT NULL,
  `smtp_pass` varchar(100) NOT NULL,
  `smtp_crypto` varchar(50) NOT NULL,
  `mail_type` varchar(50) NOT NULL,
  `char_set` varchar(50) NOT NULL,
  `priority` tinyint(1) NOT NULL,
  `from_name` varchar(100) NOT NULL,
  `from_address` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


--
-- Table structure for table `complain_types`
--
CREATE TABLE `complain_types` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `type` varchar(120) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `complains`
--
CREATE TABLE `complains` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `academic_year_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `type_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `action_note` text,
  `complain_date` datetime DEFAULT NULL,
  `action_date` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `study_materials`
--
CREATE TABLE `study_materials` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `material` varchar(120) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `ebooks`
--
CREATE TABLE `ebooks` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `author` varchar(100) DEFAULT NULL,
  `edition` varchar(50) DEFAULT NULL,
  `language` varchar(100) DEFAULT NULL,
  `cover_image` varchar(120) DEFAULT NULL,
  `file_name` varchar(120) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `admissions`
--
CREATE TABLE `admissions` (
  `id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `dob` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `class_id` int(11) NOT NULL,
  `type_id` int(11) DEFAULT NULL,
  `group` varchar(50) DEFAULT NULL,
  `blood_group` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `religion` varchar(100) DEFAULT NULL,
  `caste` varchar(100) DEFAULT NULL,
  `health_condition` varchar(255) DEFAULT NULL,
  `national_id` varchar(100) DEFAULT NULL,
  `photo` varchar(120) DEFAULT NULL,
  `present_address` varchar(255) DEFAULT NULL,
  `permanent_address` varchar(255) DEFAULT NULL,
  `guardian_id` int(11) DEFAULT NULL,
  `gud_relation` varchar(100) DEFAULT NULL,
  `gud_name` varchar(100) DEFAULT NULL,
  `gud_phone` varchar(50) DEFAULT NULL,
  `gud_email` varchar(50) DEFAULT NULL,
  `gud_national_id` varchar(50) DEFAULT NULL,
  `gud_present_address` varchar(255) DEFAULT NULL,
  `gud_permanent_address` varchar(255) DEFAULT NULL,
  `gud_profession` varchar(100) DEFAULT NULL,
  `gud_religion` varchar(100) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `father_phone` varchar(50) DEFAULT NULL,
  `father_education` varchar(100) DEFAULT NULL,
  `father_profession` varchar(100) DEFAULT NULL,
  `father_designation` varchar(100) DEFAULT NULL,
  `mother_name` varchar(100) DEFAULT NULL,
  `mother_phone` varchar(50) DEFAULT NULL,
  `mother_education` varchar(100) DEFAULT NULL,
  `mother_profession` varchar(100) DEFAULT NULL,
  `mother_designation` varchar(100) DEFAULT NULL,
  `previous_school` varchar(255) DEFAULT NULL,
  `previous_class` varchar(100) DEFAULT NULL,
  `second_language` varchar(120) DEFAULT NULL,
  `status` tinyint(1) NOT NULL COMMENT '0 = New, 1 = Waiting, 2 = Decline, 3 = Approved',
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


--
-- Indexes for table `admissions`
--
ALTER TABLE `admissions`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ebooks`
--
ALTER TABLE `ebooks`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `study_materials`
--
ALTER TABLE `study_materials`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `complains`
--
ALTER TABLE `complains`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `complain_types`
--
ALTER TABLE `complain_types`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

--
-- Indexes for table `email_settings`
--
ALTER TABLE `email_settings`
  ADD PRIMARY KEY (`id`);


--
-- Indexes for table `leave_applications`
--
ALTER TABLE `leave_applications`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `leave_types`
--
ALTER TABLE `leave_types`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

--
-- Indexes for table `id_card_settings`
--
ALTER TABLE `id_card_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

--
-- Indexes for table `admit_card_settings`
--
ALTER TABLE `admit_card_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

--
-- Indexes for table `postal_receives`
--
ALTER TABLE `postal_receives`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

--
-- Indexes for table `postal_dispatches`
--
ALTER TABLE `postal_dispatches`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);


--
-- Indexes for table `phone_call_logs`
--
ALTER TABLE `phone_call_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);


--
-- Indexes for table `student_types`
--
ALTER TABLE `student_types`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);


--
-- Indexes for table `visitor_purposes`
--
ALTER TABLE `visitor_purposes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);


--
-- AUTO_INCREMENT for table `admissions`
--
ALTER TABLE `admissions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


--
-- AUTO_INCREMENT for table `ebooks`
--
ALTER TABLE `ebooks`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `study_materials`
--
ALTER TABLE `study_materials`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `complains`
--
ALTER TABLE `complains`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `complain_types`
--
ALTER TABLE `complain_types`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `email_settings`
--
ALTER TABLE `email_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `leave_applications`
--
ALTER TABLE `leave_applications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `leave_types`
--
ALTER TABLE `leave_types`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `id_card_settings`
--
ALTER TABLE `id_card_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `admit_card_settings`
--
ALTER TABLE `admit_card_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `postal_receives`
--
ALTER TABLE `postal_receives`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `postal_dispatches`
--
ALTER TABLE `postal_dispatches`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `phone_call_logs`
--
ALTER TABLE `phone_call_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


--
-- AUTO_INCREMENT for table `student_types`
--
ALTER TABLE `student_types`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `visitor_purposes`
--
ALTER TABLE `visitor_purposes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;



-- schools table
ALTER TABLE `schools` ADD `map_api_key` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `school_lng`;
ALTER TABLE `schools` CHANGE `phone` `phone` VARCHAR(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL;
ALTER TABLE `schools` CHANGE `currency` `currency` VARCHAR(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL;
ALTER TABLE `schools` CHANGE `registration_date` `registration_date` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;
ALTER TABLE `schools` ADD `frontend_logo` VARCHAR(120) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL AFTER `logo`;
ALTER TABLE `schools` ADD `enable_online_admission` TINYINT(1) NOT NULL DEFAULT '0' AFTER `enable_frontend`;
ALTER TABLE `schools` DROP `session_start_month`, DROP `session_end_month`;

-- global_settings table
ALTER TABLE `global_setting` ADD `brand_title` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `brand_name`;
ALTER TABLE `global_setting` CHANGE `brand_name` `brand_name` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL;
ALTER TABLE `global_setting` ADD `favicon_icon` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL AFTER `front_logo`;
ALTER TABLE `global_setting` DROP `front_logo`;
ALTER TABLE `global_setting` ADD `theme_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `enable_frontend`;

-- System admin--
ALTER TABLE `system_admin` DROP `theme_name`;

-- visitors table--
ALTER TABLE `visitors` DROP `coming_from`;
ALTER TABLE `visitors` DROP `reason`;
ALTER TABLE `visitors` ADD `purpose_id` INT(11) NOT NULL AFTER `user_id`;
ALTER TABLE `visitors` ADD `class_id` INT(11) NULL AFTER `user_id`;


-- payment setting --
ALTER TABLE `payment_settings` ADD `stack_secret_key` VARCHAR(120) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `paytm_status`, ADD `stack_public_key` VARCHAR(120) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `stack_secret_key`, ADD `stack_demo` TINYINT(1) NULL AFTER `stack_public_key`, ADD `stack_extra_charge` DECIMAL(3,2) NULL AFTER `stack_demo`, ADD `stack_status` TINYINT(1) NULL AFTER `stack_extra_charge`;

-- Transaction -------
ALTER TABLE `transactions` ADD `stack_reference` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL AFTER `stripe_card_number`;

-- SMS Setting ----
ALTER TABLE `sms_settings` ADD `betasms_username` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `smscountry_status`, ADD `betasms_password` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `betasms_username`, ADD `betasms_sender_id` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `betasms_password`, ADD `betasms_status` TINYINT(1) NOT NULL AFTER `betasms_sender_id`;


-- Student table --
ALTER TABLE `students` ADD `type_id` INT(11) NOT NULL AFTER `user_id`;
ALTER TABLE `students` ADD `caste` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `religion`;
ALTER TABLE `students` CHANGE `blood_group` `blood_group` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;

-- Expenditure--
ALTER TABLE `expenditures` ADD `reference` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `expenditure_via`;

-- books --
ALTER TABLE `books` CHANGE `edition` `edition` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;
ALTER TABLE `books` CHANGE `language` `language` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;
ALTER TABLE `books` CHANGE `cover` `cover` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;


-- Language label alter----
DELETE FROM `languages` WHERE `languages`.`id` = 247;
DELETE FROM `languages` WHERE `languages`.`id` = 272;
DELETE FROM `languages` WHERE `languages`.`id` = 273;
DELETE FROM `languages` WHERE `languages`.`id` = 274;
DELETE FROM `languages` WHERE `languages`.`id` = 275;
DELETE FROM `languages` WHERE `languages`.`id` = 277;
DELETE FROM `languages` WHERE `languages`.`id` = 245;

INSERT INTO `languages` (`id`, `label`, `english`, `bengali`, `spanish`, `arabic`, `hindi`, `urdu`, `chinese`, `japanese`, `portuguese`, `russian`, `french`, `korean`, `german`, `italian`, `thai`, `hungarian`, `dutch`, `latin`, `indonesian`, `turkish`, `greek`, `persian`, `malay`, `telugu`, `tamil`, `gujarati`, `polish`, `ukrainian`, `panjabi`, `romanian`, `burmese`, `yoruba`, `hausa`) VALUES
(855, 'protocol', 'Protocol', 'প্রোটোকল', 'Protocolo', 'بروتوكول', 'मसविदा बनाना', 'پروٹوکول', '协议', 'プロトコル', 'Protocolo', NULL, 'Protocole', '실험 계획안', 'Protokoll', 'Protocollo', 'โปรโตคอล', 'Protokoll', 'Protocol', 'protocol', 'Protokol', 'Protokol', 'Πρωτόκολλο', 'پروتکل', 'Protokol', 'ప్రోటోకాల్', 'நெறிமுறை', 'પ્રોટોકોલ', 'Protokół', 'Протокол', 'ਪ੍ਰੋਟੋਕੋਲ', 'Protocol', 'ပရိုတိုကော', 'Ilana', 'Protocol'),
(918, 'fee_type_instruction_hostel_1', 'Hostel Fee Amount Will be define in Hostel Room creation time.', 'হোস্টেল ফি হোস্টেল রুম তৈরির সময় নির্ধারণ করা হবে।', 'El importe de la tarifa del albergue se definirá en el tiempo de creación de la habitación del albergue.', 'سيتم تحديد قيمة رسوم Hostel Hostel في وقت إنشاء غرفة Hostel Hostel.', 'हॉस्टल शुल्क राशि हॉस्टल के कमरे के निर्माण समय में परिभाषित की जाएगी।', 'ہاسٹل کی فیس کی رقم ہاسٹل روم تخلیق کے وقت میں متعین کی جائے گی۔', 'Hostel Fee Amount将在Hostel Room创建时间中定义。', 'ホステル料金は、ホステルルームの作成時に定義されます。', 'O valor da taxa do albergue será definido no horário de criação do quarto do albergue.', 'Стоимость хостела будет определена во время создания комнаты хостела.', 'Montant des frais d’auberge Sera défini lors de la création de la chambre d’auberge.', '호스텔 요금 금액은 호스텔 객실 생성 시간으로 정의됩니다.', 'Hostel-Gebührenbetrag Wird in der Erstellungszeit des Hostel-Zimmers definiert.', 'L\'importo della tassa di ostello sarà definito al momento della creazione della stanza dell\'ostello.', 'จำนวนค่าธรรมเนียมของโฮสเทลจะถูกกำหนดในเวลาสร้างห้องโฮสเทล', 'A hosteldíj összegét a Hostel szoba létrehozásának idején határozzuk meg.', 'Hostel Fee Bedrag zal worden bepaald in het creëren van Hostel Room.', 'Hostel hostel volutpat pretium moles erit define creaturae est in tempore.', 'Jumlah Biaya Hostel akan ditentukan dalam waktu pembuatan Kamar Hostel.', 'Hostel Ücreti Tutarı, Hostel Odası oluşturma süresinde tanımlanacaktır.', 'Hostel Χρέωση Ποσό Θα καθοριστεί στην ώρα δημιουργίας δωμάτιο δωμάτιο.', 'میزان هزینه خوابگاه در زمان ایجاد اتاق خواب مشخص خواهد شد.', 'Jumlah Bayaran Kos Asrama Akan ditentukan dalam Asrama Masa penciptaan bilik.', 'హాస్టల్ ఫీజు మొత్తం హాస్టల్ గది సృష్టి సమయంలో నిర్వచించబడుతుంది.', 'விடுதி கட்டணம் தொகை விடுதி அறை உருவாக்கும் நேரத்தில் வரையறுக்கப்படும்.', 'છાત્રાલયની ફી બનાવવાની રકમ હોસ્ટેલના રૂમ બનાવટ સમયે નક્કી કરવામાં આવશે.', 'Kwota opłaty za hostel zostanie określona w czasie tworzenia pokoju w hostelu.', 'Сума плати за хостел визначатиметься у часі створення номеру хостелу.', 'ਹੋਸਟਲ ਦੀ ਫੀਸ ਦੀ ਰਕਮ ਹੋਸਟਲ ਦੇ ਕਮਰਾ ਬਣਾਉਣ ਦੇ ਸਮੇਂ ਵਿੱਚ ਪ੍ਰਭਾਸ਼ਿਤ ਕੀਤੀ ਜਾਏਗੀ.', 'Valoarea tarifelor pentru hostel va fi definită în timpul de creare a camerei Hostel.', 'ဘော်ဒါဆောင်ကြေးငွေပမာဏဘော်ဒါဆောင်အခန်းဖန်ဆင်းခြင်းကာလ၌သတ်မှတ်လိမ့်မည်။', 'Iye iye ayagbe Ile ayagbe ni yoo ṣe alaye ni akoko ẹda ti Ile ayagbe.', 'Adadin Dakunan kwanan Dakunan kwanan za a ayyana a lokacin ƙirƙirar Room Dakunan kwanan yara.'),
(919, 'fee_type_instruction_hostel_2', 'From here must be create Hostel Fee Title to create Hostel Fee Invoice.', 'হোস্টেল ফি চালান তৈরি করতে অবশ্যই হোস্টেল ফি শিরোনাম তৈরি করতে হবে এখান থেকে।', 'A partir de aquí debe crearse el Título de tarifa de albergue para crear la Factura de tarifa de albergue.', 'من هنا يجب إنشاء عنوان رسوم Hostel Hostel لإنشاء فاتورة Hostel Fee.', 'यहाँ से Hostel Fee Invoice बनाने के लिए Hostel Fee Title बनाना होगा।', 'ہاسٹل فیس انوائس بنانے کے لئے یہاں سے ہاسٹل فیس ٹائٹل بنانا ضروری ہے۔', '从这里必须创建Hostel Fee Title以创建Hostel Fee Invoice。', 'ここから、ホステル料金請求書を作成するために、ホステル料金タイトルを作成する必要があります。', 'A partir daqui, deve ser criado o título da taxa do albergue para criar a fatura da taxa do albergue.', 'Отсюда необходимо создать Hostel Fee Title для создания Hostel Fee Invoice.', 'Créez un titre de taxe d’auberge pour créer une facture de taxe d’auberge.', '여기에서 호스텔 요금 청구서를 작성하려면 호스텔 요금 제목을 작성해야합니다.', 'Von hier aus muss ein Hostelgebührentitel erstellt werden, um eine Hostelgebühr-Rechnung zu erstellen.', 'Da qui è necessario creare il titolo della tariffa dell\'ostello per creare la fattura della quota dell\'ostello.', 'จากที่นี่จะต้องสร้างชื่อค่าธรรมเนียมหอพักเพื่อสร้างใบแจ้งหนี้ค่าธรรมเนียมหอพัก', 'Innentől létre kell hozni a Hostel Díj címét a Hostel Díj számla létrehozásához.', 'Vanaf hier moet Hostel Fee Titel worden gemaakt om Hostel Fee Factuur te maken.', 'Hinc oportet creare hostel hostel pretium pretium Titulus creare cautionem.', 'Dari sini harus dibuat Judul Biaya Hostel untuk membuat Faktur Biaya Hostel.', 'Buradan Pansiyon Ücreti Faturası oluşturmak için Pansiyon Ücreti Başlığı oluşturulmalıdır.', 'Από εδώ πρέπει να δημιουργήσετε τον Τίτλο του Τέλους Hostel για να δημιουργήσετε το Τιμολόγιο Φόρουμ Hostel.', 'از اینجا باید عنوان Hostel Fee عنوان ایجاد کنید تا فاکتور هزینه خوابگاه را تهیه کنید.', 'Dari sini mesti mewujudkan Title Fee Hostel untuk membuat Invois Bayaran Hostel.', 'ఇక్కడ నుండి హాస్టల్ ఫీజు ఇన్వాయిస్ సృష్టించడానికి హాస్టల్ ఫీజు శీర్షికను సృష్టించాలి.', 'இங்கிருந்து விடுதி கட்டண விலைப்பட்டியலை உருவாக்க விடுதி கட்டண தலைப்பை உருவாக்க வேண்டும்.', 'છાત્રાલય ફી ભરતિયું બનાવવા માટે અહીંથી છાત્રાલય ફીનું શીર્ષક બનાવવું આવશ્યક છે.', 'Stąd należy utworzyć tytuł opłaty za hostel, aby utworzyć fakturę za opłatę za hostel.', 'Звідси потрібно створити назву комісійної комісії, щоб створити рахунок-фактуру за хостел.', 'ਹੋਸਟਲ ਫੀਸ ਇਨਵੌਇਸ ਬਣਾਉਣ ਲਈ ਇੱਥੇ ਤੋਂ ਹੋਸਟਲ ਫੀਸ ਦਾ ਸਿਰਲੇਖ ਹੋਣਾ ਲਾਜ਼ਮੀ ਹੈ.', 'De aici trebuie să se creeze titlul de taxe pentru pensii pentru a crea factura de taxe la hostel.', 'ဒီကနေဘော်ဒါဆောင်ကြေးငွေတောင်းခံလွှာကိုဖန်တီးရန်ဘော်ဒါဆောင်ကြေးခေါင်းစဉ်ဖန်တီးရမည်ဖြစ်သည်။', 'Lati ibi gbọdọ jẹ ṣẹda Akọle ayagbe Ile ayagbe lati ṣẹda Invoice Ile ayagbe hostel.', 'Daga nan dole ne a ƙirƙiri taken Dakunan kwanan Mai ba da izini don ƙirƙirar Injin Dadi Mai masaukin baki.'),
(920, 'fee_type_instruction_transport_1', 'Transport Fee Amount Will be define in Transport Route creation time.', 'পরিবহন রুট তৈরির সময় পরিবহন ফি পরিমাণ নির্ধারণ করা হবে।', 'El importe de la tarifa de transporte se definirá en el tiempo de creación de la ruta de transporte.', 'سيتم تحديد مبلغ رسوم النقل في وقت إنشاء طريق النقل.', 'परिवहन शुल्क राशि परिवहन मार्ग निर्माण समय में परिभाषित की जाएगी।', 'ٹرانسپورٹ روٹ کی تخلیق کے وقت میں ٹرانسپورٹ کی فیس کی رقم متعین کی جائے گی۔', '运输费用金额将在运输路线创建时间中定义。', '輸送料金の金額は、輸送ルートの作成時に定義されます。', 'O valor da taxa de transporte será definido no horário de criação da rota de transporte.', 'Сумма транспортного сбора будет определена во время создания транспортного маршрута.', 'Le montant des frais de transport sera défini dans l\'heure de création de l\'itinéraire de transport.', '운송 비용 금액은 운송 경로 생성 시간에 정의됩니다.', 'Der Betrag der Transportgebühr wird in der Erstellungszeit des Transportwegs definiert.', 'L\'importo della tassa di trasporto verrà definito al momento della creazione della rotta di trasporto.', 'จำนวนค่าธรรมเนียมการขนส่งจะถูกกำหนดในเวลาสร้างเส้นทางการขนส่ง', 'A szállítási díj összegét a szállítási útvonal létrehozási ideje határozza meg.', 'Het bedrag van de transportkosten wordt bepaald in de aanmaaktijd van de transportroute.', 'Aliquam pretium onerariam navem onerariam in define voluntas creaturae Iter itineris est.', 'Jumlah Biaya Transportasi akan ditentukan dalam waktu pembuatan Rute Transportasi.', 'Nakliye Ücreti Tutarı, Nakliye Rotası oluşturma süresinde tanımlanacaktır.', 'Ποσό τέλους μεταφοράς Θα οριστεί στην ώρα δημιουργίας διαδρομής μεταφοράς.', 'مقدار هزینه حمل و نقل در زمان ایجاد مسیر حمل و نقل مشخص خواهد شد.', 'Jumlah Bayaran Pengangkutan Akan ditentukan dalam Masa Penjanaan Laluan Pengangkutan.', 'రవాణా రుసుము మొత్తం రవాణా మార్గం సృష్టి సమయంలో నిర్వచించబడుతుంది.', 'போக்குவரத்து பாதை தொகை போக்குவரத்து பாதை உருவாக்கும் நேரத்தில் வரையறுக்கப்படும்.', 'પરિવહન ફીની રકમ ટ્રાન્સપોર્ટ રૂટ બનાવટના સમયમાં નિર્ધારિત કરવામાં આવશે.', 'Wysokość opłaty transportowej zostanie określona w czasie tworzenia trasy transportowej.', 'Сума транспортної плати визначатиметься у часі створення транспортного маршруту.', 'ਟਰਾਂਸਪੋਰਟ ਫੀਸ ਦੀ ਰਕਮ ਟਰਾਂਸਪੋਰਟ ਰੂਟ ਬਣਾਉਣ ਦੇ ਸਮੇਂ ਵਿੱਚ ਪ੍ਰਭਾਸ਼ਿਤ ਕੀਤੀ ਜਾਏਗੀ.', 'Valoarea tarifelor de transport va fi definită în timpul de creare a traseului de transport.', 'ပို့ဆောင်ရေးကြေးငွေပမာဏပို့ဆောင်ရေးလမ်းကြောင်းဖန်ဆင်းခြင်းကာလ၌သတ်မှတ်လိမ့်မည်။', 'Iye isanwo Irinṣẹ Yoo ṣalaye ni akoko Irinṣẹ Irinṣẹ.', 'Adadin Kudin Sufuri Zai Iya Bayyanawa a Lokacin Hada Jirgin Sama.'),
(921, 'fee_type_instruction_transport_2', 'From here must be create Transport Fee Title to create Transport Fee Invoice.', 'পরিবহন ফি চালান তৈরি করতে এখান থেকে অবশ্যই পরিবহন ফি শিরোনাম তৈরি করতে হবে।', 'A partir de aquí debe crearse el Título de tarifa de transporte para crear la Factura de tarifa de transporte.', 'من هنا يجب إنشاء عنوان رسوم النقل لإنشاء فاتورة رسوم النقل.', 'यहाँ से Transport Fee Invoice बनाने के लिए Transport Fee Title बनाना होगा।', 'ٹرانسپورٹ فیس انوائس بنانے کیلئے یہاں سے ٹرانسپورٹ فیس ٹائٹل بنانا ضروری ہے۔', '从这里必须创建运输费标题以创建运输费发票。', '輸送費請求書を作成するには、ここから輸送費タイトルを作成する必要があります。', 'A partir daqui, deve ser criado o título da taxa de transporte para criar a fatura da taxa de transporte.', 'Отсюда необходимо создать Название транспортной пошлины, чтобы создать Счет на оплату транспортных расходов.', 'À partir de là, vous devez créer un titre de frais de transport pour créer une facture de frais de transport.', '여기에서 운송료 청구서를 작성하려면 운송료 제목을 작성해야합니다.', 'Von hier aus muss der Transportgebührentitel erstellt werden, um die Transportgebührenrechnung zu erstellen.', 'Da qui deve essere creato il titolo della tassa di trasporto per creare la fattura della tassa di trasporto.', 'จากที่นี่จะต้องสร้างชื่อค่าธรรมเนียมการขนส่งเพื่อสร้างใบแจ้งหนี้ค่าขนส่ง', 'Innentől létre kell hozni a szállítási díj címét a szállítási díj számla létrehozásához.', 'Vanaf hier moet u Transporttitel maken om Transportfactuurfactuur te maken.', 'Hinc oportet creare pretium onerariam Titulus creare pretium onerariam cautionem.', 'Dari sini harus dibuat Judul Biaya Transportasi untuk membuat Faktur Biaya Transportasi.', 'Buradan, Taşıma Ücreti Faturası oluşturmak için Taşıma Ücreti Başlığı oluşturulmalıdır.', 'Από εδώ πρέπει να δημιουργηθεί τίτλος τέλους μεταφοράς για να δημιουργηθεί τιμολόγιο μεταφοράς.', 'از اینجا باید عنوان ایجاد هزینه حمل و نقل برای ایجاد فاکتور حمل و نقل هزینه ایجاد کنید.', 'Dari sini mesti mencipta Tajuk Bayaran Pengangkutan untuk membuat Invois Bayaran Pengangkutan.', 'రవాణా ఫీజు ఇన్వాయిస్ సృష్టించడానికి ఇక్కడ నుండి రవాణా ఫీజు శీర్షికను సృష్టించాలి.', 'போக்குவரத்து கட்டண விலைப்பட்டியலை உருவாக்க இங்கிருந்து போக்குவரத்து கட்டண தலைப்பை உருவாக்க வேண்டும்.', 'અહીંથી ટ્રાન્સપોર્ટ ફી ઇન્વoiceઇસ બનાવવા માટે પરિવહન ફીનું શીર્ષક બનાવવું આવશ્યક છે.', 'Stąd należy utworzyć tytuł opłaty transportowej, aby utworzyć fakturę opłaty transportowej.', 'Звідси слід створити назву транспортної плати, щоб створити рахунок за транспортну плату.', 'ਇੱਥੇ ਤੋਂ ਟਰਾਂਸਪੋਰਟ ਫੀਸ ਇਨਵੌਇਸ ਬਣਾਉਣ ਲਈ ਟਰਾਂਸਪੋਰਟ ਫੀਸ ਸਿਰਲੇਖ ਹੋਣਾ ਲਾਜ਼ਮੀ ਹੈ.', 'De aici trebuie să se creeze titlul comisionului de transport pentru a crea factura taxelor de transport.', 'ဒီကနေပို့ဆောင်ရေးကြေးငွေတောင်းခံလွှာကိုဖန်တီးရန်ပို့ဆောင်ရေးကြေးခေါင်းစဉ်ဖန်တီးရမည်ဖြစ်သည်။', 'Lati ibi gbọdọ wa ni ṣẹda Akọọlẹ owo ọya lati ṣẹda Invoice Fee Invoice.', 'Daga nan dole ne a ƙirƙiri Fati Fee Title don ƙirƙirar Lissafin Kuɗi na Kuɗi.'),
(922, 'caste', 'Caste', 'জাত', 'Casta Casta', 'الطائفة', 'जाति', 'ذات۔', '种姓', 'カースト', 'Casta', 'каста', 'Caste', '카스트', 'Kaste', 'Casta', 'วรรณะ', 'Kaszt', 'Kaste', 'caste', 'Kasta', 'Kast', 'Κοινωνική τάξη', 'کاست', 'Kasta', 'కులం', 'ஜாதி', 'જાતિ', 'Kasta', 'Каста', 'ਜਾਤ', 'Castă', 'ဇာတ်', 'Caste', 'Caste'),
(856, 'smtp', 'SMTP', 'এসএমটিপি ', 'SMTP', 'SMTP', 'एसएमटीपी', 'ایس ایم ٹی پی۔', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'ESMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'SMTP', 'சார்ந்த SMTP', 'એસ.એમ.ટી.પી.', 'SMTP', 'SMTP', 'ਐਸਐਮਟੀਪੀ', 'SMTP', 'SMTP', 'SMTP', 'SMTP'),
(857, 'host', 'Host', 'হোস্ট', 'Anfitriona', 'مضيف', 'मेज़बान', 'میزبان۔', '主办', 'ホスト', 'Hospedeira', 'хозяин', 'Hôtesse', '숙주', 'Wirt', 'Ospite', 'เจ้าภาพ', 'Házigazda', 'Gastheer', 'exercitum', 'Tuan rumah', 'evsahibi', 'Πλήθος', 'میزبان', 'Hos', 'హోస్ట్', 'தொகுப்பாளர்', 'હોસ્ટ', 'Gospodarz', 'Господар', 'ਹੋਸਟ', 'Gazdă', 'host က', 'Gbalejo', 'Mai watsa shiri'),
(858, 'port', 'Port', 'পোর্ট', 'Puerto', 'ميناء', 'बंदरगाह', 'پورٹ', '港口', '港', 'Porta', 'порт', 'Port', '포트', 'Hafen', 'Porta', 'ท่าเรือ', 'Kikötő', 'Haven', 'Portus', 'Pelabuhan', 'Liman', 'Λιμάνι', 'بندر', 'Pelabuhan', 'పోర్ట్', 'போர்ட்', 'બંદર', 'Port', 'Порт', 'ਪੋਰਟ', 'Port', 'ဆိပ်ကမ်း', 'Port', 'Tashar jiragen ruwa'),
(859, 'time_out', 'Time Out', 'টাইম আউট', 'Se acabó el tiempo', 'نفذ الوقت', 'समय समाप्त', 'وقت ختم', '超时', 'タイムアウト', 'Tempo esgotado', 'Время истекло', 'Temps libre', '타임 아웃', 'Auszeit', 'Tempo scaduto', 'หมดเวลา', 'Időtúllépés', 'Time-out', 'Ex Tempus', 'Waktu habis', 'Zaman aşımı', 'Τέλος χρόνου', 'زمان گذشته', 'Masa tamat', 'సమయం ముగిసినది', 'நேரம் முடிந்தது', 'સમય સમાપ્ત થયો', 'Koniec czasu', 'Час вийшов', 'ਸਮਾਂ ਖ਼ਤਮ', 'Pauză', 'ခဏပွဲရပ်ခြင်း', 'Duro na', 'Lokaci Lokaci'),
(860, 'security', 'Security', 'সিকিউরিটি', 'Seguridad', 'الأمان', 'सुरक्षा', 'سیکیورٹی', '安全', 'セキュリティ', 'Segurança', 'Безопасность', 'Sécurité', '보안', 'Sicherheit', 'Sicurezza', 'ความปลอดภัย', 'Biztonság', 'Veiligheid', 'Security', 'Keamanan', 'Güvenlik', 'Ασφάλεια', 'امنیت', 'Keselamatan', 'సెక్యూరిటీ', 'பாதுகாப்பு', 'સુરક્ષા', 'Bezpieczeństwo', 'Безпека', 'ਸੁਰੱਖਿਆ', 'Securitate', 'လုံခွုံရေး', 'Aabo', 'Tsaro'),
(861, 'char_set', 'Char Set', 'ক্যারেক্টার  সেট', 'Conjunto de char', 'مجموعة تشار', 'चार सेट', 'چار سیٹ۔', '字符集', 'チャーセット', 'Conjunto de caracteres', 'Набор символов', 'Jeu de caractères', '문자 세트', 'Char Set', 'Set di caratteri', 'ชุดถ่าน', 'Char szett', 'Char Set', 'Set char', 'Char Set', 'Char Seti', 'Char Set', 'مجموعه های برجسته', 'Set Caj', 'చార్ సెట్', 'சார் செட்', 'ચાર સેટ', 'Char Set', 'Набір Чар', 'ਚਾਰ ਸੈੱਟ', 'Char Set', 'char သတ်မှတ်မည်', 'Ṣeto Ṣeto', 'Char Saiti'),
(862, 'priority', 'Priority', 'প্রায়োরিটি', 'Prioridad', 'أفضلية', 'प्राथमिकता', 'ترجیح', '优先', '優先度', 'Prioridade', 'приоритет', 'Priorité', '우선 순위', 'Priorität', 'Priorità', 'ลำดับความสำคัญ', 'Kiemelten fontos', 'Prioriteit', 'PRAECELLENTIA', 'Prioritas', 'öncelik', 'Προτεραιότητα', 'اولویت', 'Keutamaan', 'ప్రాధాన్యత', 'முன்னுரிமை', 'પ્રાથમિકતા', 'Priorytet', 'Пріоритет', 'ਤਰਜੀਹ', 'Prioritate', 'ဦးစားပေး', 'Ipilẹṣẹ', 'Fifiko'),
(863, 'complain', 'Complain', 'অভিযোগ', 'Quejar', 'تذمر', 'शिकायत', 'شکایت کریں۔', '抱怨', '文句を言う', 'Reclamar', 'Пожаловаться', 'Se plaindre', '불평', 'Beschweren', 'Lamentarsi', 'บ่น', 'Panaszkodik', 'Klagen', 'queri', 'Mengeluh', 'Şikayet', 'κανω παραπονα', 'شكايت كردن', 'Mengadu', 'ఫిర్యాదు', 'புகார்', 'ફરિયાદ કરો', 'Skarżyć się', 'Поскаржитися', 'ਸ਼ਿਕਾਇਤ', 'plânge', 'တိုင်ကြား', 'Ẹdun ọkan', 'Gunaguni'),
(864, 'study', 'Study', 'অধ্যয়ন', 'Estudiar', 'دراسة', 'अध्ययन', 'مطالعہ۔', '研究', '調査', 'Estude', 'Изучение', 'Étude', '연구', 'Studie', 'Studia', 'ศึกษา', 'Tanulmány', 'Studie', 'studium', 'Belajar', 'Ders çalışma', 'Μελέτη', 'مطالعه', 'Kajian', 'స్టడీ', 'ஆய்வு', 'અભ્યાસ', 'Badanie', 'Вивчення', 'ਅਧਿਐਨ ਕਰੋ', 'Studiu', 'လေ့လာချက်', 'Ikẹkọ', 'Nazari'),
(865, 'material', 'Material', 'উপাদান', 'Material', 'مواد', 'सामग्री', 'مٹیریل۔', '材料', '素材', 'Material', 'материал', 'Matériel', '자료', 'Material', 'Materiale', 'วัสดุ', 'Anyag', 'Materiaal', 'material', 'Bahan', 'Malzeme', 'Υλικό', 'مواد', 'Bahan', 'మెటీరియల్', 'பொருள்', 'સામગ્રી', 'Materiał', 'Матеріал', 'ਪਦਾਰਥ', 'Material', 'ပစ္စည်း', 'Ohun elo', 'Kayan aiki'),
(866, 'e_book', 'E-Book', 'ই-বুক', 'Libro electronico', 'الكتاب الاليكتروني', 'ई-बुक', 'ای بک۔', '电子书', '電子書籍', 'E-Book', 'Электронная книга', 'Livre électronique', '전자 책', 'E-Book', 'E-Book', 'E-Book', 'E-Book', 'E-Book', 'E-', 'E-Book', 'E-Kitap', 'Ηλεκτρονικό βιβλίο', 'کتاب الکترونیکی', 'E-Book', 'E- బుక్', 'மின் புத்தக', 'ઇ-બુક', 'E-Book', 'Електронна книга', 'ਈ-ਬੁੱਕ', 'E-Book', 'E-စာအုပ်', 'Iwe-iwe', 'Littattafai E-Book'),
(867, 'read', 'Read', 'পড়া', 'Leer', 'اقرأ', 'पढ़ना', 'پڑھیں', '读', '読む', 'Ler', 'Читать', 'Lis', '독서', 'Lesen', 'Leggere', 'อ่าน', 'Olvas', 'Lezen', 'Legere', 'Baca baca', 'okumak', 'Ανάγνωση', 'خواندن', 'Baca', 'చదవండి', 'படிக்க', 'વાંચવું', 'Czytać', 'Прочитайте', 'ਪੜ੍ਹੋ', 'Citit', 'ဖတ်', 'Ka', 'Karanta'),
(868, 'online', 'Online', 'অনলাইন', 'En línea', 'عبر الانترنت', 'ऑनलाइन', 'آن لائن', '线上', 'オンライン', 'Conectadas', 'онлайн', 'En ligne', '온라인', 'Online', 'in linea', 'ออนไลน์', 'Online', 'Online', 'Online', 'On line', 'İnternet üzerinden', 'Online', 'آنلاین', 'Online', 'ఆన్లైన్', 'ஆன்லைன்', 'ઓનલાઇન', 'online', 'Інтернет', 'ਨਲਾਈਨ', 'Pe net', 'အွန်လိုင်း', 'Ayelujara', 'Yanar gizo'),
(869, 'apply_successful', 'Online application successfully submitted', 'অনলাইন আবেদন সফলভাবে জমা দেওয়া হয়েছে', 'Solicitud en línea enviada con éxito', 'تم تقديم الطلب عبر الإنترنت بنجاح', 'ऑनलाइन आवेदन सफलतापूर्वक सबमिट किया गया', 'آن لائن درخواست کامیابی کے ساتھ جمع کرائی گئی۔', '在线申请成功提交', 'オンライン申請が正常に送信されました', 'Inscrição online enviada com sucesso', 'Онлайн заявка успешно отправлена', 'Demande en ligne soumise avec succès', '온라인 신청서가 성공적으로 제출되었습니다', 'Online-Bewerbung erfolgreich eingereicht', 'Domanda online inviata correttamente', 'ส่งใบสมัครออนไลน์สำเร็จแล้ว', 'Az online jelentkezés sikeresen benyújtva', 'Online aanvraag succesvol ingediend', 'Summitto bene online application', 'Aplikasi online berhasil dikirim', 'Online başvuru başarıyla gönderildi', 'Η ηλεκτρονική αίτηση υποβλήθηκε με επιτυχία', 'برنامه آنلاین با موفقیت ارسال شد', 'Permohonan dalam talian berjaya dihantar', 'ఆన్‌లైన్ దరఖాస్తు విజయవంతంగా సమర్పించబడింది', 'ஆன்லைன் விண்ணப்பம் வெற்றிகரமாக சமர்ப்பிக்கப்பட்டது', 'Applicationનલાઇન એપ્લિકેશન સફળતાપૂર્વક સબમિટ કરી', 'Aplikacja online została pomyślnie przesłana', 'Онлайн-заявка успішно подана', 'Applicationਨਲਾਈਨ ਅਰਜ਼ੀ ਸਫਲਤਾਪੂਰਵਕ ਦਰਜ ਕੀਤੀ ਗਈ', 'Cererea online a fost trimisă cu succes', 'အွန်လိုင်းလျှောက်လွှာကိုအောင်မြင်စွာတင်သွင်း', 'Ohun elo ori ayelujara ni ifijišẹ silẹ', 'An yi nasarar gabatar da aikace-aikacen kan layi cikin nasara'),
(870, 'apply_failed', 'Online application submitted failed. Please try again.', 'জমা দেওয়া অনলাইন আবেদন ব্যর্থ। অনুগ্রহপূর্বক আবার চেষ্টা করুন.', 'Solicitud en línea enviada fallida. Inténtalo de nuevo.', 'فشل تقديم الطلب عبر الإنترنت. حاول مرة اخرى.', 'ऑनलाइन आवेदन विफल रहा। कृपया पुन: प्रयास करें।', 'آن لائن درخواست جمع کروائی گئی۔ دوبارہ کوشش کریں.', '在线申请提交失败。 请再试一次。', 'オンライン申請が失敗しました。 もう一度試してください。', 'A inscrição online enviada falhou. Por favor, tente novamente.', 'Онлайн-заявка подана не удалось. Пожалуйста, попробуйте еще раз.', 'L\'application en ligne soumise a échoué. Veuillez réessayer.', '온라인 신청이 실패했습니다. 다시 시도하십시오.', 'Online-Bewerbung fehlgeschlagen. Bitte versuche es erneut.', 'Domanda online inviata non riuscita. Per favore riprova.', 'ส่งใบสมัครออนไลน์ล้มเหลว กรุณาลองอีกครั้ง.', 'A benyújtott online pályázat sikertelen. Kérlek próbáld újra.', 'Online aanvraag ingediend is mislukt. Probeer het opnieuw.', 'Online application submitted defecit. Quaero, iterum conare.', 'Aplikasi online yang diajukan gagal. Silakan coba lagi.', 'Gönderilen çevrimiçi başvuru başarısız oldu. Lütfen tekrar deneyin.', 'Η υποβολή ηλεκτρονικής αίτησης απέτυχε. ΠΑΡΑΚΑΛΩ προσπαθησε ξανα.', 'درخواست آنلاین ارسال نشد. لطفا دوباره تلاش کنید.', 'Permohonan dalam talian yang dikemukakan gagal. Sila cuba lagi.', 'సమర్పించిన ఆన్‌లైన్ దరఖాస్తు విఫలమైంది. దయచేసి మళ్ళీ ప్రయత్నించండి.', 'சமர்ப்பிக்கப்பட்ட ஆன்லைன் விண்ணப்பம் தோல்வியுற்றது. தயவுசெய்து மீண்டும் முயற்சி செய்க.', 'સબમિટ થયેલ applicationનલાઇન અરજી નિષ્ફળ. મહેરબાની કરીને ફરીથી પ્રયતન કરો.', 'Złożenie wniosku online nie powiodło się. Proszę spróbuj ponownie.', 'Не вдалося подати онлайн-заявку. Будь ласка спробуйте ще раз.', 'ਜਮ੍ਹਾਂ ਹੋਈ applicationਨਲਾਈਨ ਅਰਜ਼ੀ ਅਸਫਲ ਰਹੀ. ਮੁੜ ਕੋਸ਼ਿਸ ਕਰੋ ਜੀ.', 'Cererea online trimisă nu a reușit. Vă rugăm să încercați din nou.', 'တင်သွင်းအွန်လိုင်းလျှောက်လွှာမအောင်မြင်ခဲ့ပေ။ ထပ်ကြိုးစားပါ။', 'Ohun elo ori ayelujara silẹ ti kuna. Jọwọ gbiyanju lẹẹkansi.', 'Aikace-aikcen kan layi akan kasa sun kasa. Da fatan za a sake gwadawa.'),
(871, 'approve', 'Approve', 'অনুমোদন', 'Aprobar', 'يوافق', 'मंजूर', 'منظور کریں۔', '批准', '承認する', 'Aprovar', 'Утвердить', 'Approuver', '승인', 'Genehmigen', 'Approvare', 'อนุมัติ', 'Jóváhagy', 'Goedkeuren', 'probant', 'Menyetujui', 'onaylamak', 'Εγκρίνω', 'تایید', 'Terima', 'ఆమోదించడానికి', 'ஒப்புதல்', 'મંજૂર', 'Zatwierdzać', 'Затвердити', 'ਮਨਜ਼ੂਰ', 'Aproba', 'အတည်ပြု', 'Fi ọwọ si', 'Amincewa'),
(872, 'approved', 'Approved', 'অনুমোদিত', 'Aprobada', 'وافق', 'मंजूर की', 'منظورشدہ', '批准', '承認済み', 'Aprovada', 'Одобренный', 'Approuvée', '승인', 'Genehmigt', 'Approvato', 'ได้รับการอนุมัติ', 'Jóváhagyott', 'aangenomen', 'probatus', 'Disetujui', 'onaylı', 'Εγκρίθηκε', 'تایید شده', 'Diluluskan', 'ఆమోదించబడింది', 'அங்கீகரிக்கப்பட்ட', 'મંજુર', 'Zatwierdzony', 'Затверджено', 'ਮਨਜ਼ੂਰ', 'Aprobat', 'approved', 'Ti a fọwọsi', 'An yarda'),
(873, 'decline', 'Decline', 'প্রত্যাখ্যান', 'Disminución', 'انخفاض', 'पतन', 'رد', '下降', NULL, 'Declínio', 'снижение', 'Déclin', '쇠퇴', 'Ablehnen', 'Declino', 'ปฏิเสธ', 'Hanyatlás', 'Afwijzen', 'declines', 'Menurun', 'düşüş', 'Πτώση', 'کاهش می یابد', 'Tolak', 'డిక్లైన్', 'சரிவு', 'ઘટી', 'Upadek', 'Спад', 'ਅਸਵੀਕਾਰ', 'Declin', 'ဆင်းလာ', 'Kọ', 'Ragewa'),
(874, 'declined', 'Declined', 'প্রত্যাখান', 'Rechazado', 'رفض', 'इंकार कर दिया', 'رد۔', '下降', '不承認', 'Recusada', 'Отклонено', 'Diminuée', '거부', 'Abgelehnt', 'rifiutato', 'ปรับตัวลดลง', 'Elutasította', 'Afgewezen', 'declinavi ex ea', 'Ditolak', 'Reddedilen', 'Απορρίφθηκε', 'نپذیرفتن', 'Ditolak', 'తిరస్కరించబడింది', 'நிராகரிக்கப்பட்டது', 'નકારવું', 'Odrzucony', 'Відхилено', 'ਅਸਵੀਕਾਰ ਕਰ ਦਿੱਤਾ', 'Refuzat', 'ငြင်းဆန်', 'Kikọ', 'Ya ki'),
(875, 'favicon_icon', 'Favicon Icon', 'ফ্যাভিকন আইকন', 'Icono de favicon', 'أيقونة فافيكون', 'फ़ेविकॉन आइकन', 'فیویکون آئیکن', 'Favicon图标', 'ファビコンアイコン', 'Favicon Ícone', 'Фавикон Иконка', 'Icône Favicon', 'Favicon 아이콘', 'Favicon Icon', 'Icona Favicon', 'ไอคอน Favicon', 'Favicon ikonra', 'Favicon-pictogram', 'Icon favicon', 'Ikon Favicon', 'Favicon Simgesi', 'Εικονίδιο Favicon', 'نماد Favicon', 'Ikon Favicon', 'ఫావికాన్ ఐకాన్', 'ஃபேவிகான் ஐகான்', 'ફેવિકોન ચિહ્ન', 'Ikona Favicon', 'Ікона Фавікона', 'ਫੇਵੀਕਨ ਆਈਕਨ', 'Pictograma Favicon', 'စိတ်ကြိုက်အိုင်ကွန်အိုင်ကွန်', 'Favicon Aami', 'Favicon Icon'),
(876, 'card', 'Card', 'কার্ড', 'Tarjeta', 'بطاقة', 'कार्ड', 'کارڈ', '卡', 'カード', 'Cartão', 'Карта', 'Carte', '카드', 'Karte', 'Carta', 'บัตร', 'Kártya', 'Kaart', 'Card', 'Kartu', 'kart', 'Κάρτα', 'کارت', 'Kad', 'కార్డ్', 'அட்டை', 'કાર્ડ', 'Karta', 'Картка', 'ਕਾਰਡ', 'Card', 'ကဒ်', 'Kaadi', 'Katin'),
(877, 'leave', 'Leave', 'ছুটি ', 'Salir', 'غادر', 'छोड़ना', 'چھوڑ دو۔', '离开', '去る', 'Sair', 'Покидать', 'Laisser', '휴가', 'Verlassen', 'Partire', 'ออกจาก', 'Szabadság', 'Het verlof', 'relinquo', 'Meninggalkan', 'Ayrılmak', 'Αδεια', 'ترک کردن', 'Tinggalkan', 'వదిలి', 'விட்டு', 'રજા', 'Wyjechać', 'Залишати', 'ਛੱਡੋ', 'Părăsi', 'ထွက်သွား', 'Lọ', 'Fita'),
(878, 'reason', 'Reason', 'কারণ', 'Razón', 'السبب', 'कारण', 'وجہ۔', '原因', '理由', 'Razão', 'причина', 'Raison', '이유', 'Grund', 'Ragionare', 'เหตุผล', 'Ok', 'Reden', 'ratio', 'Alasan', 'neden', 'Λόγος', 'دلیل', 'Sebab', 'కారణము', 'காரணம்', 'કારણ', 'Powód', 'Причина', 'ਕਾਰਨ', 'Motiv', 'အကွောငျးရငျး', 'Idi', 'Dalili'),
(879, 'application', 'Application', 'আবেদন', 'Solicitud', NULL, 'आवेदन', 'درخواست۔', '应用', '応用', 'Aplicação', 'заявка', 'Application', '신청', 'Anwendung', 'Applicazione', 'ใบสมัคร', 'Alkalmazás', 'Toepassing', 'application', 'Aplikasi', 'Uygulama', 'Εφαρμογή', 'کاربرد', 'Permohonan', 'అప్లికేషన్', 'விண்ணப்ப', 'એપ્લિકેશન', 'Podanie', 'Застосування', 'ਐਪਲੀਕੇਸ਼ਨ', 'cerere', 'လြှောကျလှာ', 'Ohun elo', 'Aikace-aikacen'),
(880, 'applicant', 'Applicant', 'আবেদক', 'Solicitante', 'طالب وظيفة', 'आवेदक', 'درخواست دہندہ۔', '申请人', '応募者', 'Candidato', 'заявитель', 'Demandeur', '응모자', 'Antragsteller', 'Richiedente', 'ผู้ขอ', 'Pályázó', 'aanvrager', 'applicant', 'Pemohon', 'Başvuru sahibi', 'Αιτών', 'درخواست کننده', 'Pemohon', 'దరఖాస్తుదారు', 'விண்ணப்பதாரர்', 'અરજદાર', 'Petent', 'Заявник', 'ਬਿਨੈਕਾਰ', 'Solicitant', 'လြှောကျသူ', 'Ibẹwẹ', 'Mai nema'),
(881, 'to_date_must_be_big', 'To date must be greater than From date', 'টু  ডেট  অবশ্যই  ফ্রম  ডেট  থেকে বড় হতে হবে', 'Hasta la fecha debe ser mayor que Desde la fecha', 'يجب أن يكون التاريخ أكبر من تاريخ', 'आज तक की तारीख से अधिक होना चाहिए', 'آج تک تاریخ سے زیادہ ہونا چاہئے۔', '迄今为止必须大于From日期', '終了日は開始日よりも大きくする必要があります', 'Até a data deve ser maior que a partir da data', 'На сегодняшний день должно быть больше, чем с даты', 'À ce jour doit être supérieur à la date de début', '종료 날짜는 시작 날짜보다 커야합니다', 'Bis Datum muss größer als Von Datum sein', 'Ad oggi deve essere maggiore di Da data', 'ถึงวันที่จะต้องมากกว่าวันที่', 'A dátumnak nagyobbnak kell lennie, mint a dátumtól', 'Tot datum moet groter zijn dan vanaf datum', 'Ad date debet esse a major diem', 'Tanggal harus lebih besar dari Tanggal', 'Tarih, Kimden tarihinden büyük olmalı', 'Μέχρι σήμερα πρέπει να είναι μεγαλύτερη από Από την ημερομηνία', 'تا به امروز باید بیشتر از تاریخ باشد', 'Sehingga kini mesti lebih besar dari tarikh Dari', 'తేదీ నుండి తేదీ కంటే ఎక్కువగా ఉండాలి', 'இன்றுவரை தேதியை விட அதிகமாக இருக்க வேண்டும்', 'આજની તારીખ તારીખથી મોટી હોવી જોઈએ', 'Do tej pory musi być większa niż od daty', 'На сьогоднішній день має бути більше, ніж з дати', 'ਤਾਰੀਖ ਤੋਂ ਤਾਰੀਖ ਤੋਂ ਵੱਡਾ ਹੋਣਾ ਚਾਹੀਦਾ ਹੈ', 'Până în prezent trebuie să fie mai mare decât De la dată', 'ယနေ့အထိနေ့စွဲမှစထက် သာ. ကြီးမြတ်ဖြစ်ရမည်', 'Lati ọjọ gbọdọ tobi ju Lati ọjọ lọ', 'Zuwa yau dole ne ya fi Na zamani'),
(882, 'to', 'To', 'টু ', NULL, 'إلى', 'सेवा मेरे', 'کرنا', '至', 'に', 'Para', 'к', 'À', '에', 'Zu', 'A', 'ไปยัง', 'Nak nek', 'Naar', 'Ad', 'Untuk', 'için', 'Προς το', 'به', 'Untuk', 'టు', 'செய்ய', 'થી', 'Do', 'До', 'ਨੂੰ', 'La', 'သို့', 'Si', 'Zuwa'),
(883, 'top', 'Top', 'টপ', NULL, NULL, 'चोटी', 'اوپر', '最佳', '上', 'Topo', 'верхний', 'Haut', '상단', 'oben', 'Superiore', 'ด้านบน', 'felső', 'Top', 'Top', 'Teratas', 'Üst', 'Μπλουζα', 'بالا', 'Teratas', 'టాప్', 'சிறந்த', 'ટોચ', 'Top', 'Зверху', 'ਸਿਖਰ', 'Top', 'ထိပ်တန်း', 'Oke', 'Sama'),
(884, 'bottom', 'Bottom', 'বটম', NULL, 'الأسفل', 'तल', 'نیچے', '底部', '底', 'Inferior', 'Низ', 'Bas', '바닥', 'Unterseite', 'Parte inferiore', 'ด้านล่าง', 'Alsó', 'Bodem', 'solum', 'Bawah', 'Alt', 'Κάτω μέρος', 'پایین', 'Bawah', 'దిగువ', 'பாட்டம்', 'નીચે', 'Dolny', 'Знизу', 'ਤਲ', 'Fund', 'အောကျခွေ', 'Isalẹ', 'Kasa'),
(885, 'font_size', 'Font Size', 'ফন্ট সাইজ', 'Tamaño de fuente', 'حجم الخط', 'फ़ॉन्ट आकार', 'حرف کا سائز', '字体大小', 'フォントサイズ', 'Tamanho da fonte', 'Размер шрифта', 'Taille de police', '폰트 크기', 'Schriftgröße', 'Dimensione del font', 'ขนาดตัวอักษร', 'Betűméret', 'Lettertypegrootte', 'font Size', 'Ukuran huruf', 'Yazı Boyutu', 'Μέγεθος γραμματοσειράς', 'اندازه فونت', 'Saiz huruf', 'ఫాంట్ పరిమాణం', 'எழுத்துரு அளவு', 'અક્ષર ની જાડાઈ', 'Rozmiar czcionki', 'Розмір шрифту', 'ਫੋਂਟ ਆਕਾਰ', 'Marimea fontului', 'font Size ကို', 'Iwọn Font', 'Girman Font'),
(886, 'color', 'Color', 'কালার', 'Color', 'اللون', 'रंग', 'رنگ', '颜色', '色', 'Cor', 'цвет', 'Couleur', '색깔', 'Farbe', 'Colore', 'สี', 'Szín', 'Kleur', 'color', 'Warna', 'Renk', 'Χρώμα', 'رنگ', 'Warna', 'రంగు', 'நிறம்', 'રંગ', 'Kolor', 'Колір', 'ਰੰਗ', 'Culoare', 'အရောင်', 'Awọ', 'Launi'),
(887, 'no', 'No', 'নম্বর', 'No', 'لا', 'नहीं', 'نہیں', '没有', 'いや', 'Não', 'нет', 'Non', '아니', 'Nein', 'No', 'ไม่', 'Nem', 'Nee', 'nullum', 'Tidak', 'Yok hayır', 'Οχι', 'نه', 'Tidak', 'తోబుట్టువుల', 'இல்லை', 'ના', 'Nie', 'Ні', 'ਨਹੀਂ', 'Nu', 'အဘယ်သူမျှမ', 'Rara', 'A\'a'),
(888, 'value', 'Value', 'ভ্যালু', 'Valor', 'القيمة', 'मूल्य', 'قدر', '值', '値', 'Valor', 'Значение', 'Valeur', '값', 'Wert', 'Valore', 'ราคา', 'Érték', 'Waarde', 'valorem', 'Nilai', 'değer', 'αξία', 'ارزش', 'Nilai', 'విలువ', 'மதிப்பு', 'મૂલ્ય', 'Wartość', 'Значення', 'ਮੁੱਲ', 'Valoare', 'အဘိုး', 'Iye', 'Daraja'),
(889, 'signature', 'Signature', 'স্বাক্ষর', 'Firma', 'التوقيع', 'हस्ताक्षर', 'دستخط', '签名', '署名', 'Assinatura', 'Подпись', 'Signature', '서명', 'Unterschrift', 'Firma', 'ลายเซ็น', 'Aláírás', 'Handtekening', 'subscriptio', 'Tanda tangan', 'İmza', 'Υπογραφή', 'امضا', 'Tandatangan', 'సంతకం', 'கையொப்பம்', 'સહી', 'Podpis', 'Підпис', 'ਦਸਤਖਤ', 'Semnătură', 'လက်မှတ်', 'Ibuwọlu', 'Sa hannu'),
(890, 'align', 'Align', 'এলাইন', 'Alinear', 'محاذاة', 'संरेखित', 'سیدھ میں لائیں۔', '对齐', '整列', 'Alinhar', 'выравнивать', 'Aligner', '정렬', 'Ausrichten', 'Allineare', 'เป็นเส้นตรง', 'Igazítsa', 'richten', 'Conlineare', 'Meluruskan', 'hizalama', 'Ευθυγραμμίζω', 'تراز کردن', 'Align', 'సమలేఖనం', 'சீரமை', 'સંરેખિત કરો', 'Wyrównać', 'Вирівняти', 'ਇਕਸਾਰ', 'Alinia', 'တန်း။ တား', 'Parapọ', 'A daidaita'),
(891, 'visitor', 'Visitor', 'পরিদর্শক', 'Visitante', 'زائر', 'आगंतुक', 'ملاقاتی۔', '游客', 'ビジター', 'Visitante', 'посетитель', 'Visiteuse', '방문객', 'Besucher', 'Visitatrice', 'ผู้มาเยือน', 'Látogató', 'Bezoeker', 'visitor', 'Pengunjung', 'Ziyaretçi', 'Επισκέπτης', 'بازدید کننده', 'Pelawat', 'సందర్శకుల', 'வருகையாளர்', 'મુલાકાતી', 'Gość', 'Відвідувач', 'ਯਾਤਰੀ', 'Vizitator', 'ဧည့်သည်', 'Alejo', 'Baƙo'),
(892, 'purpose', 'Purpose', 'উদ্দেশ্য', 'Propósito', 'غرض', 'उद्देश्य', 'مقصد۔', '目的', '目的', 'Finalidade', 'Цель', 'Objectif', '목적', 'Zweck', 'Scopo', 'วัตถุประสงค์', 'Célja', 'Doel', 'rem', 'Tujuan', 'amaç', 'Σκοπός', 'هدف', 'Tujuan', 'పర్పస్', 'நோக்கம்', 'હેતુ', 'Cel, powód', 'Призначення', 'ਉਦੇਸ਼', 'Scop', 'ရည်ရွယ်ချက်', 'Idi', 'Manufa'),
(893, 'front_office', 'Front Office', 'ফ্রন্ট অফিস', 'Oficina frontal', 'مكتب الإستقبال', 'फ्रंट कार्यालय', 'سامنے والا دفتر', '前厅', 'フロントオフィス', 'Front Office', 'Фронт-офис', 'Front Office', '프론트 오피스', 'Vorderbüro', 'Sportello', 'หน้าสำนักงาน', 'Front Office', 'Front Office', 'Fronte officium', 'Kantor depan', 'Ön ofis', 'Μπροστινό γραφείο', 'دفتر جلو', 'Pejabat Depan', 'ఫ్రంట్ ఆఫీస్', 'முன் அலுவலகம்', 'આગળ ની ઓફિસ', 'Front Office', 'Фронт-офіс', 'ਸਾਹਮਣੇ ਦੇ ਦਫ਼ਤਰ', 'Front office', 'တပ်ဦးရုံး', 'Iwaju Iwaju', 'Ofishin gaba'),
(894, 'call_log', 'Call Log', 'কল লগ', 'Registro de llamadas', 'سجل المكالمات', 'कॉल लॉग', 'کال کی فہرست', '通话记录', '通話記録', 'Registro de chamadas', 'Журнал вызовов', 'Journal d\'appel', '통화 기록', 'Anrufliste', 'Registro chiamate', 'บันทึกการโทร', 'Hívásnapló', 'Oproeplogboek', 'Log voca', 'Laporan panggilan', 'Çağrı geçmişi', 'Μητρώο κλήσεων', 'تماس تلفنی', 'Log panggilan', 'కాల్ లాగ్', 'அழைப்பு பதிவு', 'લ Callગ ક Callલ કરો', 'Rejestr połączeń', 'Журнал викликів', 'ਕਾਲ ਲੌਗ', 'Jurnal de Apel', 'ဖုန်းခေါ်ဆိုမှုမှတ်တမ်း', 'Wọle Wọle', 'Kiran Kira'),
(895, 'postal', 'Postal', 'পোস্টাল', 'Postal', 'بريدي', 'डाक का', 'پوسٹل۔', '邮政', '郵便', 'Postal', 'почтовый', 'Postale', '우편 엽서', 'Post', 'postale', 'ไปรษณีย์', 'Postai', 'Post', 'Praesent', 'Pos', 'Posta', 'Ταχυδρομικός', 'پستی', 'Pos', 'పోస్టల్', 'தபால்', 'ટપાલ', 'Pocztowy', 'Поштовий', 'ਡਾਕ', 'Poştal', 'စာတိုက်', 'Ifiweranṣẹ', 'Adireshin'),
(896, 'dispatch', 'Dispatch', 'ডাকপ্রেরণ', 'Envío', 'إيفاد', 'प्रेषण', 'بھیجنا۔', '调度', 'ディスパッチ', 'Despacho', 'отправка', 'Envoi', '급파', 'Versand', 'Spedizione', 'ฆ่า', 'Elküldés', 'Verzending', 'expedite', 'Pengiriman', 'Sevk etmek', 'Επιστολή', 'اعزام', 'Penghantaran', 'డిస్పాచ్', 'டிஸ்பேட்ஜ்', 'રવાનગી', 'Wysyłka', 'Відправлення', 'ਭੇਜਣਾ', 'Expediere', 'dispatch', 'Ṣọpa', 'Ragewa'),
(897, 'receive', 'Receive', 'গ্রহণ করা', 'Recibir', 'تسلم', 'प्राप्त करना', 'وصول کریں۔', '接收', '受け取る', 'Receber', 'Получать', 'Recevoir', '받다', 'Erhalten', 'Ricevere', 'รับ', 'Kap', 'Te ontvangen', 'accipite', 'Menerima', 'Teslim almak', 'Λαμβάνω', 'دريافت كردن', 'Terima', 'స్వీకరించండి', 'பெறுக', 'પ્રાપ્ત કરો', 'Otrzymać', 'Отримати', 'ਪ੍ਰਾਪਤ ਕਰੋ', 'A primi', 'ခံယူ', 'Gba', 'Karba'),
(898, 'incoming', 'Incoming', 'ইনকামিং', 'Entrante', 'الوارد', 'आने वाली', 'آنے والی۔', '来', '着信', 'Entrada', 'вступающий', 'Entrante', NULL, 'Eingehend', 'in arrivo', 'ขาเข้า', 'Beérkező', 'inkomend', 'ineuntes', 'Masuk', 'Gelen', 'Εισερχόμενος', 'ورودی', 'Masuk', 'ఇన్కమింగ్', 'வருகை', 'ઇનકમિંગ', 'Przychodzące', 'Вхідний', 'ਆਉਣ ਵਾਲੀ', 'care sosește', 'incoming', 'Ti nwọle', 'Mai shigowa'),
(899, 'outgoing', 'Outgoing', 'আউটগোয়িং', 'Saliente', 'المنتهية', 'निवर्तमान', 'سبکدوش ہونے والے', '传出', NULL, 'Extrovertida', 'исходящий', 'Sortante', '나가는', 'Ausgehend', 'Estroversa', 'ขาออก', 'Kimenő', 'uitgaande', 'exitus', 'Keluar', 'Dışına dönük', 'Εξερχόμενος', 'برونگرا', 'Keluar', 'అవుట్గోయింగ్', 'வெளிச்செல்லும்', 'આઉટગોઇંગ', 'Towarzyski', 'Вихідні', 'ਆgoingਟਗੋਇੰਗ', 'De ieșire', 'အထွက်', 'Ti njade', 'Mai fita'),
(900, 'call_type', 'Call Type', 'কল টাইপ', 'Tipo de llamada', 'نوع الاتصال', 'कॉल प्रकार', 'کال کی قسم', '通话类型', NULL, 'Tipo de chamada', 'Тип звонка', 'Type d\'appel', '통화 유형', 'Anrufart', 'Tipo di chiamata', 'ประเภทการโทร', 'Hívás típusa', 'Oproeptype', 'vocationem Type', 'Jenis Panggilan', 'Çağrı tipi', 'Τύπος κλήσης', 'نوع تماس', 'Jenis Panggilan', 'కాల్ రకం', 'அழைப்பு வகை', 'ક Callલનો પ્રકાર', 'Rodzaj połączenia', 'Тип дзвінка', 'ਕਾਲ ਦੀ ਕਿਸਮ', 'Tip apel', 'ခေါ်ရန်အမျိုးအစား', 'Iru Ipe', 'Nau\'in Kira'),
(901, 'call_duration', 'Call Duration', 'কল সময়কাল', 'Duración de la llamada', 'مدة المكالمة', 'कॉल की अवधि', 'کال کا دورانیہ', '通话时长', '通話時間', 'Duraçao da chamada', 'Длительность звонка', 'Durée d\'appel', '통화 시간', 'Gesprächsdauer', 'Durata della chiamata', 'ระยะเวลาการโทร', 'Hívás időtartam', 'Gespreksduur', 'Duration vocatio', 'Durasi panggilan', 'Çağrı süresi', 'Διάρκεια κλήσης', 'مدت زمان تماس', 'Tempoh Panggilan', 'కాల్ వ్యవధి', 'அழைப்பு காலம்', 'ક Callલ અવધિ', 'Długość rozmowy', 'Тривалість дзвінка', 'ਕਾਲ ਅੰਤਰਾਲ', 'Durata apelului', 'Duration: Call', 'Akoko Ipe', 'Lokacin Kira'),
(902, 'follow_up', 'Follow Up', 'অনুসরণ', 'Seguir', 'متابعة', 'जाँच करना', 'فالو اپ', '跟进', 'ファローアップ', 'Acompanhamento', 'Следовать за', 'Suivre', '후속 조치', 'Nachverfolgen', 'Azione supplementare', 'ติดตาม', 'Követés', 'Opvolgen', 'INSEQUOR', 'Mengikuti', 'Takip et', 'Ακολουθω', 'پیگیری', 'Mengikuti', 'ఫాలో అప్', 'பின்தொடர்', 'અનુસરો', 'Zagryźć', 'Слідувати', 'Ran leti', 'Urmare', 'နောက်ဆက်တွဲ', 'Ran leti', 'Biyo Gaba'),
(903, 'call_date', 'Call Date', 'কল ডেট', 'Fecha de llamada', 'تاريخ الاتصال', 'कॉल की तारीख', 'کال کی تاریخ۔', '通话日期', '呼び出し日', 'Data da chamada', 'Дата звонка', 'Date d\'appel', '전화 날짜', 'Anrufdatum', 'Data della chiamata', 'วันที่โทร', 'Hívás dátuma', 'Oproepdatum', 'vocationem Date', 'Tanggal Panggilan', 'Çağrı tarihi', 'Ημερομηνία κλήσης', 'تاریخ تماس', 'Tarikh Panggilan', 'కాల్ తేదీ', 'அழைப்பு தேதி', 'ક Callલ તારીખ', 'Data połączenia', 'Дата виклику', 'ਕਾਲ ਦੀ ਮਿਤੀ', 'Data apelului', 'ခေါ်ရန်နေ့စွဲ', 'Ọjọ', 'Ranar Kira'),
(904, 'waiting', 'Waiting', 'প্রতীক্ষা', 'Esperando', 'انتظار', 'इंतज़ार कर रही', 'انتظار کر رہا ہے۔', '等候', '待っています', 'Esperando', 'ждущий', 'Attendre', '기다리는', 'Warten', 'Inattesa', 'ที่รอคอย', 'Várakozás', 'Aan het wachten', 'exspecto', 'Menunggu', 'bekleme', 'Αναμονή', 'در انتظار', 'Menunggu', 'వేచి', 'காத்திருக்கிறது', 'રાહ જોવી', 'Czekanie', 'Очікування', 'ਉਡੀਕ ਕਰ ਰਿਹਾ ਹੈ', 'Aşteptare', 'စောင့်ဆိုင်းနေ', 'Nduro', 'Jiran'),
(905, 'used', 'Used', 'ব্যবহৃত', 'Usada', 'مستخدم', 'उपयोग किया गया', 'استعمال کیا جاتا ہے۔', '用过的', '中古', 'Usava', 'Используемый', 'Utilisée', '익숙한', 'Gebraucht', 'Usata', 'มือสอง', 'Használt', 'Gebruikt', 'solebant', 'Bekas', 'Kullanılmış', 'Μεταχειρισμένος', 'استفاده شده', 'Digunakan', 'ఉపయోగించబడిన', 'பயன்படுத்திய', 'વપરાયેલ', 'Używany', 'Б / в', 'ਵਰਤਿਆ', 'Folosit', 'အသုံးပြုခံ့', 'Ti Lo', 'Amfani'),
(906, 'pay_stack', 'Pay Stack', 'পে স্ট্যাক', 'Pila de pago', 'دفع المكدس', 'पे स्टैक', 'تنخواہ', '支付堆栈', '有料スタック', 'Pilha de pagamento', 'Стек оплаты', 'Pile de paie', '지불 스택', 'Zahlen Sie Stapel', 'Pay Stack', 'สแต็คจ่ายเงิน', 'Pay Stack', 'Betaalstapel', 'stipendium Stack', 'Tumpukan pembayaran', 'Yığın öde', 'Στοίβα πληρωμής', 'پشته را پرداخت کنید', 'Stack Pay', 'పే స్టాక్', 'பே ஸ்டேக்', 'પે સ્ટેક', 'Pay Stack', 'Сплатити стек', 'ਤਨਖਾਹ ਸਟੈਕ', 'Pay Stack', 'Pay ကို Stack', 'Sanwo Stack', 'Biyan Stack'),
(907, 'secret_key', 'Secret Key', 'সিক্রেট কী', 'Llave secreta', 'المفتاح السري', 'गुप्त कुंजी', 'خفیہ کلید', '密钥', '秘密鍵', 'Chave secreta', 'Секретный ключ', 'Clef secrète', '비밀 키', 'Geheimer Schlüssel', 'Chiave segreta', 'รหัสลับ', 'Titkos kulcs', 'Geheime sleutel', 'Key, secret', 'Kunci rahasia', 'Gizli anahtar', 'Μυστικό κλειδί', 'کلید مخفی', 'Kunci Rahsia', 'సీక్రెట్ కీ', 'ரகசிய விசை', 'ગુપ્ત કી', 'Sekretny klucz', 'Секретний ключ', 'ਗੁਪਤ ਕੁੰਜੀ', 'Cheie secreta', 'လျှို့ဝှက် Key ကို', 'Bọtini Asiri', 'Maɓallin Sirri'),
(908, 'public_key', 'Public Key', 'পাবলিক কী', 'Llave pública', 'المفتاح العمومي', 'सार्वजनिक कुंजी', 'عوامی کلید', '公钥', '公開鍵', 'Chave pública', 'Открытый ключ', 'Clé publique', '공개 키', 'Öffentlicher Schlüssel', 'Chiave pubblica', 'กุญแจสาธารณะ', 'Nyilvános kulcs', 'Publieke sleutel', 'Key publica', 'Kunci Publik', 'Genel anahtar', 'Δημόσιο κλειδί', 'کلید عمومی', 'Kunci Awam', 'పబ్లిక్ కీ', 'பொது விசை', 'જાહેર કી', 'Klucz publiczny', 'Публічний ключ', 'ਪਬਲਿਕ ਕੁੰਜੀ', 'Cheia publică', 'Public Key ကို', 'Bọtini Gbangba', 'Makullin jama\'a'),
(909, 'beta_sms', 'Beta SMS', 'বিটা  এসএমএস', 'SMS beta', 'بيتا SMS', 'बीटा एसएमएस', 'بیٹا ایس ایم ایس۔', 'Beta短信', 'ベータ版SMS', 'Beta SMS', 'Бета СМС', 'SMS bêta', '베타 SMS', 'Beta SMS', 'Beta SMS', 'SMS Beta', 'Beta SMS', 'Beta sms', 'Beta SMS', 'SMS Beta', 'Beta SMS', 'Beta SMS', 'پیامک بتا', 'SMS Beta', 'బీటా SMS', 'பீட்டா எஸ்.எம்.எஸ்', 'બીટા એસ.એમ.એસ.', 'Beta SMS', 'Бета-SMS', 'ਬੀਟਾ ਐਸ ਐਮ ਐਸ', 'SMS-uri beta', 'beta ကို SMS စာတို', 'Beta SMS', 'Beta SMS'),
(910, 'confirm_proceed', 'Are you sure you want to proceed?', 'আপনি কি নিশ্চিত আপনি সামনে এগুতে চান?', '¿Estas seguro que deseas continuar?', 'هل انت متأكد انك تريد المتابعة؟', 'क्या आप सुनिश्चित रूप से आगे बढ़ना चाहते हैं?', 'کیا آپ واقعی آگے بڑھنا چاہتے ہیں؟', '你确定要继续吗？', '続行しますか？', 'Tem certeza de que deseja continuar?', 'Вы уверены, что хотите продолжить?', 'Êtes-vous sur de vouloir continuer?', '계속 하시겠습니까?', 'Sind Sie sicher, dass Sie fortfahren möchten?', 'Sei sicuro di voler procedere?', 'คุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อ', 'Biztosan folytatni akarja?', 'Weet je zeker dat je verder wilt gaan?', 'Certus es ire velis?', 'Anda yakin ingin melanjutkan?', 'Devam etmek istediğinize emin misiniz?', 'Είστε βέβαιοι ότι θέλετε να προχωρήσετε;', 'آیا مطمئن هستید که می خواهید ادامه دهید؟', 'Adakah anda pasti mahu meneruskan?', 'మీరు ఖచ్చితంగా కొనసాగాలని అనుకుంటున్నారా?', 'நீங்கள் நிச்சயமாக தொடர விரும்புகிறீர்களா?', 'શું તમે ખરેખર આગળ વધવા માંગો છો?', 'Na pewno chcesz kontynuować?', 'Ви впевнені, що хочете продовжити?', 'ਕੀ ਤੁਸੀਂ ਅੱਗੇ ਵੱਧਣਾ ਚਾਹੁੰਦੇ ਹੋ?', 'Ești sigur că vrei să continui?', 'သငျသညျဆက်လက်ဆောင်ရွက်လိုသောသေချာလား?', 'Ṣe o da ọ loju pe o fẹ tẹsiwaju?', 'Ka tabbata kana son ci gaba?'),
(911, 'session_start', 'Session Start', 'সেশন শুরু', 'Inicio de sesión', 'بدء الجلسة', 'सत्र प्रारंभ', 'سیشن اسٹارٹ۔', '会话开始', 'セッション開始', 'Início da sessão', 'Начало сеанса', 'Début de session', '세션 시작', 'Sitzungsstart', 'Inizio sessione', 'เริ่มเซสชัน', 'Session Start', 'Start sessie', 'Sessio Committitur', 'Mulai Sesi', 'Oturum Başlangıcı', 'Έναρξη περιόδου σύνδεσης', 'جلسه شروع', 'Mula Sesi', 'సెషన్ ప్రారంభం', 'அமர்வு தொடக்கம்', 'સત્ર પ્રારંભ', 'Rozpoczęcie sesji', 'Запуск сесії', 'ਸ਼ੈਸ਼ਨ ਅਰੰਭ', 'Începerea sesiunii', 'session Start ကို', 'Ibẹrẹ Ikilọ', 'Zama na Farko'),
(912, 'session_end', 'Session End', 'সেশন সমাপ্তি', 'Fin de sesión', 'نهاية الجلسة', 'सत्र समाप्ति', 'سیشن ختم۔', '会话结束', 'セッション終了', 'Fim da Sessão', 'Конец сессии', 'Fin de session', '세션 종료', 'Sitzungsende', 'Fine della sessione', 'สิ้นสุดเซสชัน', 'Munkamenet vége', 'Sessie einde', 'Sessio finis', 'Sesi Berakhir', 'Oturum Sonu', 'Τέλος περιόδου σύνδεσης', 'جلسه پایان', 'Akhir Sesi', 'సెషన్ ముగింపు', 'அமர்வு முடிவு', 'સત્ર સમાપ્ત', 'Koniec sesji', 'Закінчення сесії', 'ਸੈਸ਼ਨ ਅੰਤ', 'Sfârșitul sesiunii', 'session အဆုံး', 'Ipari Igba', 'Zaman Karshe'),
(913, 'backend', 'Backend', 'ব্যাক-এন্ড', 'Backend', 'الخلفية', 'बैकएंड', 'پسدید۔', '后端', 'バックエンド', 'Backend', 'Backend', 'Backend', '백엔드', 'Backend', 'backend', 'แบ็กเอนด์', 'háttér', 'backend', 'backend', 'Backend', 'Arka Ucu', 'Backend', 'پس زمینه', 'Backend', 'బ్యాకెండ్', 'பின்தளத்தில்', 'બેકએન્ડ', 'Backend', 'Бекенд', 'ਬੈਕਐਂਡ', 'backend', 'backend', 'Pada', 'Baya'),
(914, 'bulk_student_instruction_7', 'Take the Student Type ID from Student Type list', 'স্টুডেন্ট টাইপ তালিকা থেকে স্টুডেন্ট টাইপ আইডি নিন', 'Tome la identificación de tipo de estudiante de la lista de tipo de estudiante', 'خذ معرف نوع الطالب من قائمة نوع الطالب', 'छात्र प्रकार सूची से छात्र प्रकार आईडी लें', 'اسٹوڈنٹ ٹائپ لسٹ سے اسٹوڈنٹ ٹائپ ID لیں۔', '从学生类型列表中获取学生类型ID', '学生タイプリストから学生タイプIDを取得します', 'Pegue o ID do tipo de aluno na lista Tipo de aluno', 'Возьмите идентификатор типа студента из списка типа студента', 'Prenez l\'ID de type d\'étudiant dans la liste Type d\'étudiant', '학생 유형 목록에서 학생 유형 ID를 가져옵니다', 'Übernehmen Sie die Schülertyp-ID aus der Schülertyp-Liste', 'Prendi l\'ID del tipo di studente dall\'elenco Tipo di studente', 'ใช้รหัสประเภทนักศึกษาจากรายการประเภทนักศึกษา', 'Vegye ki a Student Type ID-t a Student Type listából', 'Neem de Student Type ID uit de lijst Student Type', 'Discipulus accipere id Type de Discipulus Type album', 'Ambil ID Jenis Siswa dari daftar Jenis Siswa', 'Öğrenci Türü kimliğini Öğrenci Türü listesinden alın', 'Πάρτε το αναγνωριστικό τύπου φοιτητή από τη λίστα Τύπος σπουδαστών', 'شناسه Student Student را از لیست Student Student بگیرید', 'Ambil ID Jenis Pelajar dari senarai Jenis Pelajar', 'స్టూడెంట్ టైప్ జాబితా నుండి స్టూడెంట్ టైప్ ఐడిని తీసుకోండి', 'மாணவர் வகை பட்டியலிலிருந்து மாணவர் வகை ஐடியை எடுத்துக் கொள்ளுங்கள்', 'વિદ્યાર્થી પ્રકારની સૂચિમાંથી વિદ્યાર્થી પ્રકારનો ID લો', 'Weź identyfikator typu studenta z listy typów studentów', 'Візьміть ідентифікатор типу Student зі списку Student Student', 'ਵਿਦਿਆਰਥੀ ਕਿਸਮ ਦੀ ਸੂਚੀ ਤੋਂ ਵਿਦਿਆਰਥੀ ਕਿਸਮ ਦੀ ID ਲਓ', 'Luați ID-ul Student Type din lista de tip Student', 'ကျောင်းသားအမျိုးအစား list ကနေကျောင်းသားအမျိုးအစား ID ကိုယူပါ', 'Mu Ọmọ-iwe Ọmọ-iwe Ọmọde lati inu akojọ Iru Akeko', 'IDauki ID na Dalibi na fromalibi a cikin nau\'in nau\'in ɗalibi'),
(915, 'credential', 'Credential', 'ক্রেডেনশিয়াল', 'Credencial', 'الاعتماد', 'क्रेडेंशियल', 'اسناد', '凭据', 'クレデンシャル', 'Credencial', 'мандат', 'Credential', '신임장', 'Berechtigung', 'Credenziali', 'ข้อมูลประจำตัว', 'Bizonyítvány', 'geloofsbrief', 'MANDATUM', 'Mandat', 'Kimlik', 'Πιστοποιητικό', 'اعتبارنامه', NULL, 'క్రెడెన్షియల్', 'நற்சான்று', 'ઓળખપત્ર', 'Poświadczenie', 'Посвідчення', 'ਪ੍ਰਮਾਣ ਪੱਤਰ', 'Credential', 'ယုံကြည်စိတ်ချရသော', 'Ẹri', 'Shaida'),
(916, 'reference', 'Reference', 'রেফারেন্স', 'Referencia', 'مرجع', 'संदर्भ', 'حوالہ۔', '参考', '参照', 'Referência', 'Ссылка', 'Référence', '참고', 'Referenz', 'Riferimento', 'การอ้างอิง', 'Referencia', 'Referentie', 'Reference', 'Referensi', 'Referans', 'Αναφορά', 'ارجاع', 'Rujukan', 'సూచన', 'குறிப்பு', 'સંદર્ભ', 'Odniesienie', 'Довідково', 'ਹਵਾਲਾ', 'Referinţă', 'အညွှန်း', 'Ifilo', 'Tunani'),
(917, 'border', 'Border', 'বর্ডার', 'Frontera', 'الحدود', 'सीमा', 'بارڈر۔', '边界', '境界', 'Fronteira', 'бордюр', 'Frontière', '경계', 'Rand', 'Confine', 'ชายแดน', 'Határ', 'Grens', 'terminus', 'Berbatasan', 'sınır', 'Σύνορο', 'مرز', 'Sempadan', 'బోర్డర్', 'பார்டர்', 'સરહદ', 'Granica', 'Кордон', 'ਬਾਰਡਰ', 'Frontieră', 'နယ်စပ်', 'Àla', 'Kan iyaka');



--
-- Table structure for table `themes`
--
DROP TABLE `themes`;
CREATE TABLE IF NOT EXISTS `themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL,
  `slug` varchar(120) NOT NULL,
  `color_code` varchar(10) NOT NULL,
  `description` text,
  `is_active` tinyint(1) NOT NULL COMMENT '1 = Active, 0 = Inactive',
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `themes`
--

INSERT INTO `themes` (`id`, `name`, `slug`, `color_code`, `description`, `is_active`, `status`, `created_at`, `modified_at`, `created_by`, `modified_by`) VALUES
(13, 'SlateGray ', 'slate-gray', '#2A3F54', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(2, 'Black ', 'black', '#23282d', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(14, 'LightSeaGreen ', 'light-sea-green', '#20B2AA', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(4, 'MediumPurple ', 'medium-purple', '#9370DB', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(15, 'Navy Blue', 'navy-blue', '#001f67', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(6, 'RebeccaPurple ', 'rebecca-purple', '#663399', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(16, 'Red', 'red', '#e80000', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(8, 'DodgerBlue', 'dodger-blue', '#1E90FF', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(9, 'Maroon', 'maroon', '#800000', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(10, 'DarkOrange', 'dark-orange', '#FF8C00', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(11, 'DeepPink', 'deep-pink', '#FF1493', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(5, 'LimeGreen', 'lime-green', '#32CD32', 'cbcvbced', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(1, 'Jazzberry Jam', 'jazzberry-jam', '#9F134E', 'Jazzberry Jam', 1, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(3, 'Umber', 'umber', '#745D0B', 'Umber', 0, 1, '2017-08-18 12:59:25', '2017-08-18 13:03:43', 0, 0),
(12, 'Trinidad', 'trinidad', '#CC4F26', 'Trinidad', 0, 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0),
(7, 'Radical Red', 'radical-red', '#FB2E50', 'Radical Red', 0, 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0);



-- module operation -- previledges-- 
DROP TABLE `modules`;
CREATE TABLE IF NOT EXISTS `modules` (
  `id` int(11) NOT NULL,
  `module_name` varchar(50) NOT NULL,
  `module_slug` varchar(50) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `modules`
--

INSERT INTO `modules` (`id`, `module_name`, `module_slug`, `status`, `created_at`, `modified_at`, `created_by`, `modified_by`) VALUES
(1, 'Setting', 'setting', 1, '2017-11-13 22:55:19', '2017-11-13 22:57:10', 1, 1),
(2, 'Theme', 'theme', 1, '2017-12-12 13:34:52', '0000-00-00 00:00:00', 1, 0),
(3, 'Language', 'language', 1, '2017-12-12 13:36:11', '0000-00-00 00:00:00', 1, 0),
(4, 'Administrator', 'administrator', 1, '2017-12-12 13:36:35', '0000-00-00 00:00:00', 1, 0),
(5, 'Human Resource', 'hrm', 1, '2017-12-12 13:38:30', '0000-00-00 00:00:00', 1, 0),
(6, 'Teacher', 'teacher', 1, '2017-12-12 13:39:01', '0000-00-00 00:00:00', 1, 0),
(7, 'Academic Activity', 'academic', 1, '2017-12-12 13:42:24', '0000-00-00 00:00:00', 1, 0),
(8, 'Guardian', 'guardian', 1, '2017-12-12 13:43:01', '0000-00-00 00:00:00', 1, 0),
(9, 'Student', 'student', 1, '2017-12-12 13:43:28', '0000-00-00 00:00:00', 1, 0),
(10, 'Attendance', 'attendance', 1, '2017-12-12 13:45:03', '0000-00-00 00:00:00', 1, 0),
(11, 'Assignment', 'assignment', 1, '2017-12-12 13:45:45', '0000-00-00 00:00:00', 1, 0),
(12, 'Exam', 'exam', 1, '2017-12-12 13:46:13', '0000-00-00 00:00:00', 1, 0),
(14, 'Library', 'library', 1, '2017-12-12 13:46:33', '0000-00-00 00:00:00', 1, 0),
(15, 'Transport', 'transport', 1, '2017-12-12 13:46:52', '0000-00-00 00:00:00', 1, 0),
(16, 'Hostel', 'hostel', 1, '2017-12-12 13:47:15', '0000-00-00 00:00:00', 1, 0),
(17, 'Message, Email & SMS', 'message', 1, '2017-12-12 13:47:48', '2017-12-14 08:48:49', 1, 1),
(18, 'Announcement', 'announcement', 1, '2017-12-12 13:48:23', '0000-00-00 00:00:00', 1, 0),
(19, 'Event', 'event', 1, '2017-12-12 13:48:36', '0000-00-00 00:00:00', 1, 0),
(20, 'Front Office', 'frontoffice', 1, '2017-12-12 13:49:05', '2019-08-05 22:41:52', 1, 1),
(21, 'Accounting', 'accounting', 1, '2017-12-12 13:49:32', '0000-00-00 00:00:00', 1, 0),
(22, 'Report', 'report', 1, '2017-12-12 13:51:09', '0000-00-00 00:00:00', 1, 0),
(13, 'Exam Mark', 'exam', 1, '2017-12-14 00:00:00', '2017-12-14 09:07:46', 1, 1),
(23, 'Certificate', 'certificate', 1, '2018-03-17 16:27:14', '0000-00-00 00:00:00', 2, 0),
(24, 'Media Gallery', 'gallery', 1, '2018-03-22 06:46:46', '0000-00-00 00:00:00', 1, 0),
(25, 'Frontend', 'frontend', 1, '2018-03-23 03:40:22', '0000-00-00 00:00:00', 1, 0),
(26, 'Payroll', 'payroll', 1, '2018-03-25 02:07:46', '0000-00-00 00:00:00', 1, 0),
(27, 'Complain', 'complain', 1, '2019-04-10 00:00:00', '2019-04-10 00:00:00', 1, 1),
(28, 'User Complain', 'usercomplain', 1, '2019-07-20 19:39:44', '0000-00-00 00:00:00', 1, 0),
(29, 'User Leave', 'userleave', 1, '2019-07-24 21:53:30', '0000-00-00 00:00:00', 1, 0),
(30, 'Leave Management', 'leave', 1, '2019-07-24 21:53:59', '0000-00-00 00:00:00', 1, 0),
(31, 'ID Card & Admit Card', 'card', 1, '2019-07-28 23:36:16', '0000-00-00 00:00:00', 1, 0);

--
-- Indexes for dumped tables
--

ALTER TABLE `modules`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

ALTER TABLE `modules`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;


DROP TABLE `operations`;
CREATE TABLE IF NOT EXISTS `operations` (
  `id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `operation_name` varchar(50) NOT NULL,
  `operation_slug` varchar(50) NOT NULL,
  `is_view_vissible` tinyint(1) DEFAULT '0',
  `is_add_vissible` tinyint(1) DEFAULT '0',
  `is_edit_vissible` tinyint(1) DEFAULT '0',
  `is_delete_vissible` tinyint(1) DEFAULT '0',
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `operations`
--

INSERT INTO `operations` (`id`, `module_id`, `operation_name`, `operation_slug`, `is_view_vissible`, `is_add_vissible`, `is_edit_vissible`, `is_delete_vissible`, `status`, `created_at`, `modified_at`, `created_by`, `modified_by`) VALUES
(1, 1, 'General Setting (Only Admin)', 'setting', 1, 1, 1, NULL, 1, '2017-12-12 16:06:25', '2019-09-01 14:22:34', 1, 1),
(2, 1, 'Payment Setting (Only Admin)', 'payment', 1, 1, 1, NULL, 1, '2017-12-12 16:06:55', '2019-09-01 14:23:16', 1, 1),
(3, 1, 'SMS Setting (Only Admin)', 'sms', 1, 1, 1, NULL, 1, '2017-12-12 16:07:07', '2019-09-01 14:23:01', 1, 1),
(4, 2, 'Theme', 'theme', 1, 0, 1, 0, 1, '2017-12-12 16:08:39', '2018-01-03 07:02:51', 1, 1),
(5, 3, 'Language (Only Super Admin)', 'language', 1, 1, 1, 1, 1, '2017-12-12 16:09:22', '2019-09-01 14:24:07', 1, 1),
(6, 4, 'Academic Year', 'year', 1, 1, 1, 1, 1, '2017-12-12 16:10:34', '2018-01-03 07:03:18', 1, 1),
(7, 4, 'User Role (Only Super Admin)', 'role', 1, 1, 1, 1, 1, '2017-12-12 16:10:55', '2019-09-01 15:07:08', 1, 1),
(8, 4, 'Role Permission (Only Super Admin)', 'permission', 1, NULL, 1, NULL, 1, '2017-12-12 16:12:10', '2019-09-01 14:24:55', 1, 1),
(64, 4, 'Reset User Password', 'password', 0, 0, 1, 0, 1, '2017-12-13 20:14:23', '2018-01-03 07:05:11', 1, 1),
(10, 5, 'Designation', 'designation', 1, 1, 1, 1, 1, '2017-12-12 16:15:38', '2018-01-03 07:07:38', 1, 1),
(11, 5, 'Employee', 'employee', 1, 1, 1, 1, 1, '2017-12-12 16:15:55', '2018-01-03 07:19:54', 1, 1),
(12, 6, 'Teacher', 'teacher', 1, 1, 1, 1, 1, '2017-12-12 16:17:22', '2018-01-03 07:25:07', 1, 1),
(14, 7, 'Classes', 'classes', 1, 1, 1, 1, 1, '2017-12-12 16:19:01', '2018-01-03 07:25:17', 1, 1),
(15, 7, 'Section', 'section', 1, 1, 1, 1, 1, '2017-12-12 16:19:24', '2018-01-03 07:25:24', 1, 1),
(16, 7, 'Subject', 'subject', 1, 1, 1, 1, 1, '2017-12-12 16:19:48', '2018-01-03 07:25:33', 1, 1),
(17, 7, 'Syllabus', 'syllabus', 1, 1, 1, 1, 1, '2017-12-12 16:20:32', '2018-01-03 07:25:54', 1, 1),
(18, 7, 'Class Routine', 'routine', 1, 1, 1, 1, 1, '2017-12-12 16:20:56', '2018-01-03 07:26:13', 1, 1),
(19, 7, 'Promotion', 'promotion', 1, 1, 0, 0, 1, '2017-12-12 16:21:17', '2018-02-09 01:42:57', 1, 1),
(20, 8, 'Guardian', 'guardian', 1, 1, 1, 1, 1, '2017-12-12 16:23:32', '2018-01-03 07:29:06', 1, 1),
(21, 9, 'Student', 'student', 1, 1, 1, 1, 1, '2017-12-12 17:58:56', '2018-01-03 07:29:15', 1, 1),
(65, 4, 'Backup Database (Only Super Admin)', 'backup', 1, NULL, NULL, NULL, 1, '2017-12-13 20:14:39', '2019-09-01 14:28:12', 1, 1),
(23, 10, 'Employee Attendance', 'employee', 1, 1, 1, 0, 1, '2017-12-12 18:00:10', '2018-01-03 07:30:19', 1, 1),
(24, 10, 'Teacher Attendance', 'teacher', 1, 1, 1, 0, 1, '2017-12-12 18:00:51', '2018-01-03 07:29:52', 1, 1),
(25, 10, 'Student Attendance', 'student', 1, 1, 1, 0, 1, '2017-12-12 18:01:17', '2018-01-03 07:30:01', 1, 1),
(26, 11, 'Assignment', 'assignment', 1, 1, 1, 1, 1, '2017-12-12 18:02:08', '2018-01-03 07:30:40', 1, 1),
(28, 12, 'Exam Term', 'exam', 1, 1, 1, 1, 1, '2017-12-12 18:03:30', '2018-02-09 01:49:25', 1, 1),
(29, 12, 'Exam Grade', 'grade', 1, 1, 1, 1, 1, '2017-12-12 18:03:56', '2018-01-03 07:31:56', 1, 1),
(30, 12, 'Exam Schedule', 'schedule', 1, 1, 1, 1, 1, '2017-12-12 18:04:58', '2018-01-03 07:32:14', 1, 1),
(31, 12, 'Exam Suggestion', 'suggestion', 1, 1, 1, 1, 1, '2017-12-12 18:05:18', '2018-01-03 07:32:30', 1, 1),
(32, 12, 'Exam Attendance', 'attendance', 1, 1, 1, 0, 1, '2017-12-12 18:05:43', '2018-01-03 07:32:58', 1, 1),
(33, 13, 'Exam Mark', 'mark', 1, 1, 1, 0, 1, '2017-12-12 18:06:04', '2018-01-03 07:33:16', 1, 1),
(34, 13, 'Mark Sheet', 'marksheet', 1, 1, 1, 0, 1, '2017-12-12 18:06:24', '2018-01-03 07:34:08', 1, 1),
(35, 13, 'Result', 'result', 1, 1, 1, NULL, 1, '2017-12-12 18:06:41', '2018-09-02 12:40:01', 1, 1),
(37, 14, 'Library Book', 'book', 1, 1, 1, 1, 1, '2017-12-12 18:09:17', '2018-01-03 07:36:02', 1, 1),
(38, 14, 'Library Member', 'member', 1, 1, 0, 1, 1, '2017-12-12 18:09:33', '2018-01-03 07:36:24', 1, 1),
(66, 14, 'Issue & Return', 'issue', 1, 1, 1, 0, 1, '2017-12-14 08:46:37', '2018-01-03 07:37:01', 1, 1),
(40, 15, 'Vehicle', 'vehicle', 1, 1, 1, 1, 1, '2017-12-12 18:10:49', '2018-01-03 07:37:11', 1, 1),
(41, 15, 'Transport Route', 'route', 1, 1, 1, 1, 1, '2017-12-12 18:11:17', '2018-01-03 07:41:27', 1, 1),
(42, 15, 'Transport Member', 'member', 1, 1, 0, 1, 1, '2017-12-12 18:11:39', '2018-01-03 07:41:46', 1, 1),
(43, 16, 'Hostel', 'hostel', 1, 1, 1, 1, 1, '2017-12-12 18:12:16', '2018-01-03 07:41:55', 1, 1),
(44, 16, 'Hostel Room', 'room', 1, 1, 1, 1, 1, '2017-12-12 18:12:37', '2018-01-03 07:42:02', 1, 1),
(45, 16, 'Hostel Member', 'member', 1, 1, 0, 1, 1, '2017-12-12 18:13:00', '2018-01-03 07:42:23', 1, 1),
(47, 17, 'Email', 'mail', 1, 1, 0, 1, 1, '2017-12-12 18:15:57', '2018-01-03 07:44:16', 1, 1),
(48, 17, 'Text SMS', 'text', 1, 1, 0, 1, 1, '2017-12-12 18:16:17', '2018-01-03 07:44:25', 1, 1),
(50, 18, 'Notice', 'notice', 1, 1, 1, 1, 1, '2017-12-12 18:20:38', '2018-01-03 07:47:39', 1, 1),
(51, 18, 'News', 'news', 1, 1, 1, 1, 1, '2017-12-12 18:20:54', '2018-01-03 07:47:46', 1, 1),
(52, 18, 'Holiday', 'holiday', 1, 1, 1, 1, 1, '2017-12-12 18:21:08', '2018-01-03 07:47:53', 1, 1),
(53, 19, 'Event', 'event', 1, 1, 1, 1, 1, '2017-12-12 18:21:35', '2018-01-03 07:48:00', 1, 1),
(54, 20, 'Visitor', 'visitor', 1, 1, 1, 1, 1, '2017-12-12 18:22:05', '2019-08-05 22:43:00', 1, 1),
(56, 21, 'Expenditure Head', 'exphead', 1, 1, 1, 1, 1, '2017-12-12 18:23:51', '2018-01-03 07:48:23', 1, 1),
(57, 21, 'Expenditure', 'expenditure', 1, 1, 1, 1, 1, '2017-12-12 18:24:14', '2018-01-03 07:48:32', 1, 1),
(58, 21, 'Income Head', 'incomehead', 1, 1, 1, 1, 1, '2017-12-12 18:24:42', '2018-01-03 07:48:39', 1, 1),
(59, 21, 'Income', 'income', 1, 1, 1, 1, 1, '2017-12-12 18:24:54', '2018-01-03 07:48:59', 1, 1),
(60, 21, 'Invoice', 'invoice', 1, 1, 1, 1, 1, '2017-12-12 18:25:16', '2018-01-03 07:49:12', 1, 1),
(61, 21, 'Payment', 'payment', 1, 1, 0, 0, 1, '2017-12-12 18:25:34', '2018-01-03 07:49:47', 1, 1),
(62, 22, 'Report', 'report', 1, 0, 0, 0, 1, '2017-12-12 18:26:16', '2018-01-03 07:50:00', 1, 1),
(63, 4, 'Manage User', 'user', 1, 0, 1, 0, 1, '2017-12-13 20:13:49', '2018-01-03 07:35:43', 1, 1),
(67, 13, 'Mark send by SMS', 'text', 1, 1, 0, 1, 1, '2017-12-14 09:09:58', '2018-01-03 07:34:45', 1, 1),
(68, 13, 'Mark send by Email', 'mail', 1, 1, 0, 1, 1, '2017-12-14 09:10:15', '2018-01-03 07:35:13', 1, 1),
(69, 17, 'message', 'message', 1, 1, 1, 1, 1, '2018-01-13 08:53:53', '2018-01-13 09:06:22', 2, 2),
(70, 23, 'CertificateType', 'type', 1, 1, 1, 1, 1, '2018-03-17 16:28:43', '0000-00-00 00:00:00', 2, 0),
(71, 23, 'Certificate', 'certificate', 1, NULL, NULL, NULL, 1, '2018-03-18 09:06:40', '0000-00-00 00:00:00', 1, 0),
(72, 24, 'Gallery', 'gallery', 1, 1, 1, 1, 1, '2018-03-22 06:47:27', '2018-03-22 06:48:03', 1, 1),
(73, 24, 'Image', 'image', 1, 1, 1, 1, 1, '2018-03-22 06:47:51', '0000-00-00 00:00:00', 1, 0),
(74, 25, 'Frontend', 'frontend', 1, 1, 1, 1, 1, '2018-03-23 05:06:49', '0000-00-00 00:00:00', 1, 0),
(75, 26, 'Salary Grade', 'grade', 1, 1, 1, 1, 1, '2018-03-25 02:08:21', '0000-00-00 00:00:00', 1, 0),
(76, 26, 'Payment', 'payment', 1, 1, 1, 1, 1, '2018-03-25 02:09:05', '0000-00-00 00:00:00', 1, 0),
(77, 25, 'Home Slider', 'slider', 1, 1, 1, 1, 1, '2018-03-27 18:04:48', '0000-00-00 00:00:00', 1, 0),
(78, 26, 'History', 'history', 1, NULL, NULL, NULL, 1, '2018-04-01 00:39:23', '0000-00-00 00:00:00', 1, 0),
(79, 4, 'School (Only Super Admin)', 'school', 1, 1, 1, 1, 1, '2018-05-08 18:57:28', '2019-09-01 14:26:34', 1, 1),
(81, 4, 'Payment (Only Super Admin)', 'payment', 1, 1, 1, 1, 1, '2018-08-15 00:43:44', '2019-09-01 14:27:09', 1, 1),
(82, 4, 'SMS (Only Super Admin)', 'sms', 1, 1, 1, 1, 1, '2018-08-15 00:43:58', '2019-09-01 14:27:35', 1, 1),
(83, 4, 'SMS Template', 'smstemplate', 1, 1, 1, 1, 1, '2018-08-24 18:36:20', '0000-00-00 00:00:00', 1, 0),
(84, 4, 'Email Template', 'emailtemplate', 1, 1, 1, 1, 1, '2018-08-24 18:36:46', '0000-00-00 00:00:00', 1, 0),
(85, 4, 'Activity Log', 'activitylog', 1, NULL, NULL, 1, 1, '2018-08-24 18:42:49', '0000-00-00 00:00:00', 1, 0),
(86, 9, 'Bulk Import', 'bulk', 1, 1, NULL, NULL, 1, '2018-08-28 21:13:45', '0000-00-00 00:00:00', 1, 0),
(87, 9, 'Student Activity', 'activity', 1, 1, 1, 1, 1, '2018-08-28 21:14:33', '0000-00-00 00:00:00', 1, 0),
(88, 10, 'Absent Email', 'absentemail', 1, 1, NULL, 1, 1, '2018-09-01 08:51:33', '0000-00-00 00:00:00', 1, 0),
(89, 10, 'Absent SMS', 'absentsms', 1, 1, NULL, 1, 1, '2018-09-01 08:51:50', '0000-00-00 00:00:00', 1, 0),
(90, 13, 'Exam Result', 'examresult', 1, 1, 1, NULL, 1, '2018-09-02 12:38:31', '0000-00-00 00:00:00', 1, 0),
(91, 13, 'Final Result', 'finalresult', 1, 1, 1, NULL, 1, '2018-09-02 12:41:39', '0000-00-00 00:00:00', 1, 0),
(92, 13, 'Merit List', 'meritlist', 1, NULL, NULL, NULL, 1, '2018-09-02 12:42:23', '0000-00-00 00:00:00', 1, 0),
(93, 13, 'Result Email', 'resultemail', 1, 1, NULL, 1, 1, '2018-09-02 12:43:23', '0000-00-00 00:00:00', 1, 0),
(94, 13, 'Result SMS', 'resultsms', 1, 1, NULL, 1, 1, '2018-09-02 12:43:44', '0000-00-00 00:00:00', 1, 0),
(95, 13, 'Result Card', 'resultcard', 1, NULL, NULL, NULL, 1, '2018-09-02 12:44:43', '0000-00-00 00:00:00', 1, 0),
(96, 21, 'Discount', 'discount', 1, 1, 1, 1, 1, '2018-09-10 12:33:45', '0000-00-00 00:00:00', 1, 0),
(97, 21, 'Fee Type', 'feetype', 1, 1, 1, 1, 1, '2018-09-10 12:37:06', '0000-00-00 00:00:00', 1, 0),
(98, 21, 'Due Fee Email', 'duefeeemail', 1, 1, NULL, 1, 1, '2018-09-10 12:37:40', '0000-00-00 00:00:00', 1, 0),
(99, 21, 'Due Fee SMS', 'duefeesms', 1, 1, NULL, 1, 1, '2018-09-10 12:38:04', '0000-00-00 00:00:00', 1, 0),
(100, 4, 'Super Admin (Only Super Admin)', 'superadmin', 1, 1, 1, 1, 1, '2018-09-14 17:50:59', '2019-09-01 14:23:46', 1, 1),
(101, 4, 'Guardian Feedback', 'feedback', 1, NULL, 1, 1, 1, '2018-09-14 17:55:09', '0000-00-00 00:00:00', 1, 0),
(102, 8, 'Feedback', 'feedback', 1, 1, 1, 1, 1, '2018-09-14 18:07:45', '0000-00-00 00:00:00', 1, 0),
(103, 4, 'General Setting (Only Super Admin)', 'setting', 1, 1, 1, NULL, 1, '2018-09-15 16:00:20', '2019-09-01 14:25:47', 1, 1),
(104, 25, 'About', 'about', 1, 1, 1, NULL, 1, '2018-10-10 18:16:05', '0000-00-00 00:00:00', 1, 0),
(105, 4, 'Email Setting (Only Super Admin)', 'emailsetting', 1, 1, 1, 1, 1, '2019-04-09 13:57:32', '2019-09-01 14:26:08', 1, 1),
(106, 1, 'Email Setting (Only Admin)', 'emailsetting', 1, 1, 1, NULL, 1, '2019-04-09 13:58:35', '2019-09-01 14:22:46', 1, 1),
(107, 27, 'Complain', 'complain', 1, 1, 1, 1, 1, '2019-04-10 16:22:48', '0000-00-00 00:00:00', 1, 0),
(108, 7, 'Material', 'material', 1, 1, 1, 1, 1, '2019-07-05 21:41:34', '0000-00-00 00:00:00', 1, 0),
(109, 14, 'e-book', 'ebook', 1, 1, 1, 1, 1, '2019-07-07 00:03:59', '0000-00-00 00:00:00', 1, 0),
(110, 9, 'Online Admission', 'admission', 1, NULL, 1, 1, 1, '2019-07-08 20:14:31', '2019-07-13 14:17:27', 1, 1),
(111, 27, 'Complain Type', 'type', 1, 1, 1, 1, 1, '2019-07-19 17:49:08', '0000-00-00 00:00:00', 1, 0),
(112, 28, 'User Complain (Except Super Admin)', 'usercomplain', 1, 1, 1, 1, 1, '2019-07-20 19:40:21', '2019-09-01 15:06:04', 1, 1),
(113, 29, 'User Leave (Except Super Admin)', 'userleave', 1, 1, 1, 1, 1, '2019-07-24 21:54:41', '2019-09-01 15:05:38', 1, 1),
(114, 30, 'Leave Management', 'leave', 1, 1, 1, 1, 1, '2019-07-24 21:55:23', '0000-00-00 00:00:00', 1, 0),
(115, 30, 'Leave Type', 'type', 1, 1, 1, 1, 1, '2019-07-24 21:55:51', '0000-00-00 00:00:00', 1, 0),
(116, 30, 'Leave Application', 'application', 1, 1, 1, 1, 1, '2019-07-25 16:59:43', '2019-07-25 18:21:20', 1, 1),
(117, 30, 'Waiting Leave', 'waiting', 1, NULL, 1, 1, 1, '2019-07-28 13:21:16', '0000-00-00 00:00:00', 1, 0),
(118, 30, 'Approve Leave', 'approve', 1, NULL, 1, 1, 1, '2019-07-28 13:21:46', '0000-00-00 00:00:00', 1, 0),
(119, 30, 'Decline Leave', 'decline', 1, NULL, 1, 1, 1, '2019-07-28 13:22:11', '0000-00-00 00:00:00', 1, 0),
(120, 31, 'ID & Admit card', 'card', 1, NULL, NULL, NULL, 1, '2019-07-28 23:44:54', '0000-00-00 00:00:00', 1, 0),
(121, 31, 'Teacher ID card', 'teacher', 1, NULL, NULL, NULL, 1, '2019-07-28 23:45:36', '0000-00-00 00:00:00', 1, 0),
(122, 31, 'Employee ID Card', 'employee', 1, NULL, NULL, NULL, 1, '2019-07-28 23:46:01', '0000-00-00 00:00:00', 1, 0),
(123, 31, 'Student ID card', 'student', 1, NULL, NULL, NULL, 1, '2019-07-28 23:46:40', '2019-08-03 15:23:48', 1, 1),
(124, 31, 'ID Card Setting (Only Super Admin)', 'idsetting', 1, 1, 1, 1, 1, '2019-07-30 17:27:20', '2019-09-01 15:02:05', 1, 1),
(125, 31, 'Admit Card Setting (Only Super Admin)', 'admitsetting', 1, 1, 1, 1, 1, '2019-08-03 15:25:20', '2019-09-01 15:01:35', 1, 1),
(126, 31, 'Admit card', 'admit', 1, NULL, NULL, NULL, 1, '2019-08-03 15:25:53', '0000-00-00 00:00:00', 1, 0),
(127, 31, 'School ID Setting (Only Admin)', 'schoolidsetting', 1, 1, 1, NULL, 1, '2019-08-04 13:14:03', '2019-09-01 14:21:14', 1, 1),
(128, 31, 'School Admit Setting (Only Admin)', 'schooladmitsetting', 1, 1, 1, NULL, 1, '2019-08-04 13:14:35', '2019-09-01 14:20:45', 1, 1),
(129, 20, 'Visitor Purpose', 'purpose', 1, 1, 1, 1, 1, '2019-08-05 22:43:33', '0000-00-00 00:00:00', 1, 0),
(130, 20, 'Call Logs', 'calllog', 1, 1, 1, 1, 1, '2019-08-05 22:44:06', '0000-00-00 00:00:00', 1, 0),
(131, 20, 'Postal Dispatch', 'dispatch', 1, 1, 1, 1, 1, '2019-08-05 22:44:49', '0000-00-00 00:00:00', 1, 0),
(132, 20, 'Postal Receive', 'receive', 1, 1, 1, 1, 1, '2019-08-05 22:45:19', '0000-00-00 00:00:00', 1, 0),
(133, 20, 'Front Office', 'frontoffice', 1, 1, 1, 1, 1, '2019-08-05 22:45:47', '0000-00-00 00:00:00', 1, 0),
(134, 9, 'Student Type', 'type', 1, 1, 1, 1, 1, '2019-08-17 23:11:18', '0000-00-00 00:00:00', 1, 0),
(135, 4, 'User Credential', 'usercredential', 1, NULL, NULL, NULL, 1, '2019-08-18 23:54:14', '2019-09-05 13:47:12', 1, 132);

ALTER TABLE `operations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

ALTER TABLE `operations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=136;


DROP TABLE `privileges`;
CREATE TABLE IF NOT EXISTS `privileges` (
  `id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `operation_id` int(11) NOT NULL,
  `is_add` tinyint(1) NOT NULL,
  `is_edit` tinyint(1) NOT NULL,
  `is_view` tinyint(1) NOT NULL,
  `is_delete` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `privileges`
--

INSERT INTO `privileges` (`id`, `role_id`, `operation_id`, `is_add`, `is_edit`, `is_view`, `is_delete`, `status`, `created_at`, `modified_at`, `created_by`, `modified_by`) VALUES
(1, 1, 1, 0, 0, 0, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(2, 1, 2, 0, 0, 0, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(3, 1, 3, 0, 0, 0, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(4, 1, 4, 0, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(5, 1, 5, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(6, 1, 6, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(7, 1, 7, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(8, 1, 8, 0, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(9, 1, 64, 0, 1, 0, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(10, 1, 65, 0, 0, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(11, 1, 63, 0, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(12, 1, 10, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(13, 1, 11, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(14, 1, 12, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(15, 1, 14, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(16, 1, 15, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(17, 1, 16, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(18, 1, 17, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(19, 1, 18, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(20, 1, 19, 1, 0, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(21, 1, 20, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(22, 1, 21, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(23, 1, 23, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(24, 1, 24, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(25, 1, 25, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(26, 1, 26, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(27, 1, 27, 1, 1, 1, 1, 1, '2018-01-13 09:07:29', '0000-00-00 00:00:00', 2, 0),
(28, 1, 28, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(29, 1, 29, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(30, 1, 30, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(31, 1, 31, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(32, 1, 32, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(33, 1, 33, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(34, 1, 34, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(35, 1, 35, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(36, 1, 67, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(37, 1, 68, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(38, 1, 37, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(39, 1, 38, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(40, 1, 66, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(41, 1, 40, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(42, 1, 41, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(43, 1, 42, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(44, 1, 43, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(45, 1, 44, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(46, 1, 45, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(47, 1, 46, 1, 1, 1, 1, 1, '2017-12-23 22:10:34', '0000-00-00 00:00:00', 1, 0),
(48, 1, 47, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(49, 1, 48, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(50, 1, 50, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(51, 1, 51, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(52, 1, 52, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(53, 1, 53, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(54, 1, 54, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(55, 1, 55, 1, 1, 1, 1, 1, '2017-12-23 22:10:34', '0000-00-00 00:00:00', 1, 0),
(56, 1, 56, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(57, 1, 57, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(58, 1, 58, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(59, 1, 59, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(60, 1, 60, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(61, 1, 61, 1, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(62, 1, 62, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(63, 3, 1, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(64, 3, 2, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(65, 3, 3, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(66, 3, 4, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(67, 3, 5, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(68, 3, 6, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(69, 3, 7, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(70, 3, 8, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(71, 3, 64, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(72, 3, 65, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(73, 3, 63, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(74, 3, 10, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(75, 3, 11, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(76, 3, 12, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(77, 3, 14, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(78, 3, 15, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(79, 3, 16, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(80, 3, 17, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(81, 3, 18, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(82, 3, 19, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(83, 3, 20, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(84, 3, 21, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(85, 3, 23, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(86, 3, 24, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(87, 3, 25, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(88, 3, 26, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(89, 3, 27, 1, 1, 0, 1, 1, '2018-01-03 07:12:55', '0000-00-00 00:00:00', 1, 0),
(90, 3, 28, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(91, 3, 29, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(92, 3, 30, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(93, 3, 31, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(94, 3, 32, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(95, 3, 33, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(96, 3, 34, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(97, 3, 35, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(98, 3, 67, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(99, 3, 68, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(100, 3, 37, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(101, 3, 38, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(102, 3, 66, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(103, 3, 40, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(104, 3, 41, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(105, 3, 42, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(106, 3, 43, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(107, 3, 44, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(108, 3, 45, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(109, 3, 46, 1, 1, 0, 1, 1, '2018-01-03 07:12:55', '0000-00-00 00:00:00', 1, 0),
(110, 3, 47, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(111, 3, 48, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(112, 3, 50, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(113, 3, 51, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(114, 3, 52, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(115, 3, 53, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(116, 3, 54, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(117, 3, 55, 1, 1, 0, 1, 1, '2018-01-03 07:12:55', '0000-00-00 00:00:00', 1, 0),
(118, 3, 56, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(119, 3, 57, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(120, 3, 58, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(121, 3, 59, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(122, 3, 60, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(123, 3, 61, 1, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(124, 3, 62, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(125, 1, 69, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(126, 5, 1, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(127, 5, 2, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(128, 5, 3, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(129, 5, 4, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(130, 5, 5, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(131, 5, 6, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(132, 5, 7, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(133, 5, 8, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(134, 5, 64, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(135, 5, 65, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(136, 5, 63, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(137, 5, 10, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(138, 5, 11, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(139, 5, 12, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(140, 5, 14, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(141, 5, 15, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(142, 5, 16, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(143, 5, 17, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(144, 5, 18, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(145, 5, 19, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(146, 5, 20, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(147, 5, 21, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(148, 5, 23, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(149, 5, 24, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(150, 5, 25, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(151, 5, 26, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(152, 5, 27, 1, 1, 1, 0, 1, '2018-01-13 09:46:35', '0000-00-00 00:00:00', 1, 0),
(153, 5, 28, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(154, 5, 29, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(155, 5, 30, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(156, 5, 31, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(157, 5, 32, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(158, 5, 33, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(159, 5, 34, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(160, 5, 35, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(161, 5, 67, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(162, 5, 68, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(163, 5, 37, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(164, 5, 38, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(165, 5, 66, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(166, 5, 40, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(167, 5, 41, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(168, 5, 42, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(169, 5, 43, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(170, 5, 44, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(171, 5, 45, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(172, 5, 47, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(173, 5, 48, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(174, 5, 69, 1, 1, 1, 1, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(175, 5, 50, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(176, 5, 51, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(177, 5, 52, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(178, 5, 53, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(179, 5, 54, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(180, 5, 56, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(181, 5, 57, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(182, 5, 58, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(183, 5, 59, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(184, 5, 60, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(185, 5, 61, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(186, 5, 62, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(187, 13, 1, 0, 0, 0, 0, 1, '2018-04-16 07:42:12', '0000-00-00 00:00:00', 1, 0),
(188, 13, 2, 0, 0, 0, 0, 1, '2018-04-16 07:42:12', '0000-00-00 00:00:00', 1, 0),
(189, 13, 3, 0, 0, 0, 0, 1, '2018-04-16 07:42:12', '0000-00-00 00:00:00', 1, 0),
(190, 13, 4, 0, 0, 0, 0, 1, '2018-04-16 07:42:12', '0000-00-00 00:00:00', 1, 0),
(191, 13, 5, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(192, 13, 6, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(193, 13, 7, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(194, 13, 8, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(195, 13, 64, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(196, 13, 65, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(197, 13, 63, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(198, 13, 10, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(199, 13, 11, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(200, 13, 12, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(201, 13, 14, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(202, 13, 15, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(203, 13, 16, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(204, 13, 17, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(205, 13, 18, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(206, 13, 19, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(207, 13, 20, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(208, 13, 21, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(209, 13, 23, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(210, 13, 24, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(211, 13, 25, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(212, 13, 26, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(213, 13, 27, 0, 0, 0, 0, 1, '2018-02-04 04:46:43', '0000-00-00 00:00:00', 1, 0),
(214, 13, 28, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(215, 13, 29, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(216, 13, 30, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(217, 13, 31, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(218, 13, 32, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(219, 13, 33, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(220, 13, 34, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(221, 13, 35, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(222, 13, 67, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(223, 13, 68, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(224, 13, 37, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(225, 13, 38, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(226, 13, 66, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(227, 13, 40, 0, 0, 1, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(228, 13, 41, 0, 0, 1, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(229, 13, 42, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(230, 13, 43, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(231, 13, 44, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(232, 13, 45, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(233, 13, 47, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(234, 13, 48, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(235, 13, 69, 0, 0, 1, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(236, 13, 50, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(237, 13, 51, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(238, 13, 52, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(239, 13, 53, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(240, 13, 54, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(241, 13, 56, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(242, 13, 57, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(243, 13, 58, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(244, 13, 59, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(245, 13, 60, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(246, 13, 61, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(247, 13, 62, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(248, 3, 69, 1, 1, 1, 1, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(249, 2, 1, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(250, 2, 2, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(251, 2, 3, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(252, 2, 4, 0, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(253, 2, 5, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(254, 2, 6, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(255, 2, 7, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(256, 2, 8, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(257, 2, 64, 0, 1, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(258, 2, 65, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(259, 2, 63, 0, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(260, 2, 10, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(261, 2, 11, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(262, 2, 12, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(263, 2, 14, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(264, 2, 15, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(265, 2, 16, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(266, 2, 17, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(267, 2, 18, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(268, 2, 19, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(269, 2, 20, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(270, 2, 21, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(271, 2, 23, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(272, 2, 24, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(273, 2, 25, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(274, 2, 26, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(275, 2, 28, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(276, 2, 29, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(277, 2, 30, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(278, 2, 31, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(279, 2, 32, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(280, 2, 33, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(281, 2, 34, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(282, 2, 35, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(283, 2, 67, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(284, 2, 68, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(285, 2, 37, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(286, 2, 38, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(287, 2, 66, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(288, 2, 40, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(289, 2, 41, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(290, 2, 42, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(291, 2, 43, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(292, 2, 44, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(293, 2, 45, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(294, 2, 47, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(295, 2, 48, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(296, 2, 69, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(297, 2, 50, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(298, 2, 51, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(299, 2, 52, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(300, 2, 53, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(301, 2, 54, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(302, 2, 56, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(303, 2, 57, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(304, 2, 58, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(305, 2, 59, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(306, 2, 60, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(307, 2, 61, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(308, 2, 62, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(309, 4, 1, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(310, 4, 2, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(311, 4, 3, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(312, 4, 4, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(313, 4, 5, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(314, 4, 6, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(315, 4, 7, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(316, 4, 8, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(317, 4, 64, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(318, 4, 65, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(319, 4, 63, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(320, 4, 10, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(321, 4, 11, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(322, 4, 12, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(323, 4, 14, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(324, 4, 15, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(325, 4, 16, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(326, 4, 17, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(327, 4, 18, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(328, 4, 19, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(329, 4, 20, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(330, 4, 21, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(331, 4, 23, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(332, 4, 24, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(333, 4, 25, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(334, 4, 26, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(335, 4, 28, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(336, 4, 29, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(337, 4, 30, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(338, 4, 31, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(339, 4, 32, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(340, 4, 33, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(341, 4, 34, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(342, 4, 35, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(343, 4, 67, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(344, 4, 68, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(345, 4, 37, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(346, 4, 38, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(347, 4, 66, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(348, 4, 40, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(349, 4, 41, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(350, 4, 42, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(351, 4, 43, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(352, 4, 44, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(353, 4, 45, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(354, 4, 47, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(355, 4, 48, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(356, 4, 69, 1, 1, 1, 1, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(357, 4, 50, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(358, 4, 51, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(359, 4, 52, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(360, 4, 53, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(361, 4, 54, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(362, 4, 56, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(363, 4, 57, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(364, 4, 58, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(365, 4, 59, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(366, 4, 60, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(367, 4, 61, 1, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(368, 4, 62, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(369, 6, 1, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(370, 6, 2, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(371, 6, 3, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(372, 6, 4, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(373, 6, 5, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(374, 6, 6, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(375, 6, 7, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(376, 6, 8, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(377, 6, 64, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(378, 6, 65, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(379, 6, 63, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(380, 6, 10, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(381, 6, 11, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(382, 6, 12, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(383, 6, 14, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(384, 6, 15, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(385, 6, 16, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(386, 6, 17, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(387, 6, 18, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(388, 6, 19, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(389, 6, 20, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(390, 6, 21, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(391, 6, 23, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(392, 6, 24, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(393, 6, 25, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(394, 6, 26, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(395, 6, 28, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(396, 6, 29, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(397, 6, 30, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(398, 6, 31, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(399, 6, 32, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(400, 6, 33, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(401, 6, 34, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(402, 6, 35, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(403, 6, 67, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(404, 6, 68, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(405, 6, 37, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(406, 6, 38, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(407, 6, 66, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(408, 6, 40, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(409, 6, 41, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(410, 6, 42, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(411, 6, 43, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(412, 6, 44, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(413, 6, 45, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(414, 6, 47, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(415, 6, 48, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(416, 6, 69, 1, 1, 1, 1, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(417, 6, 50, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(418, 6, 51, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(419, 6, 52, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(420, 6, 53, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(421, 6, 54, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(422, 6, 56, 1, 1, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(423, 6, 57, 1, 1, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(424, 6, 58, 1, 1, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(425, 6, 59, 1, 1, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(426, 6, 60, 1, 1, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(427, 6, 61, 1, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(428, 6, 62, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(429, 7, 1, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(430, 7, 2, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(431, 7, 3, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(432, 7, 4, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(433, 7, 5, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(434, 7, 6, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(435, 7, 7, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(436, 7, 8, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(437, 7, 64, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(438, 7, 65, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(439, 7, 63, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(440, 7, 10, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(441, 7, 11, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(442, 7, 12, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(443, 7, 14, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(444, 7, 15, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(445, 7, 16, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(446, 7, 17, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(447, 7, 18, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(448, 7, 19, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(449, 7, 20, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(450, 7, 21, 0, 0, 1, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(451, 7, 23, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(452, 7, 24, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(453, 7, 25, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(454, 7, 26, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(455, 7, 28, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(456, 7, 29, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(457, 7, 30, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(458, 7, 31, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(459, 7, 32, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(460, 7, 33, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(461, 7, 34, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(462, 7, 35, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(463, 7, 67, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(464, 7, 68, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(465, 7, 37, 1, 1, 1, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(466, 7, 38, 1, 0, 1, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(467, 7, 66, 1, 1, 1, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(468, 7, 40, 0, 0, 1, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(469, 7, 41, 0, 0, 1, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(470, 7, 42, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(471, 7, 43, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(472, 7, 44, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(473, 7, 45, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(474, 7, 47, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(475, 7, 48, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(476, 7, 69, 1, 1, 1, 1, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(477, 7, 50, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(478, 7, 51, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(479, 7, 52, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(480, 7, 53, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(481, 7, 54, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(482, 7, 56, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(483, 7, 57, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(484, 7, 58, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(485, 7, 59, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(486, 7, 60, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(487, 7, 61, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(488, 7, 62, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(489, 8, 1, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(490, 8, 2, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(491, 8, 3, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(492, 8, 4, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(493, 8, 5, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(494, 8, 6, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(495, 8, 7, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(496, 8, 8, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(497, 8, 64, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(498, 8, 65, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(499, 8, 63, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(500, 8, 10, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(501, 8, 11, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(502, 8, 12, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(503, 8, 14, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(504, 8, 15, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(505, 8, 16, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(506, 8, 17, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(507, 8, 18, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(508, 8, 19, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(509, 8, 20, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(510, 8, 21, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(511, 8, 23, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(512, 8, 24, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(513, 8, 25, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(514, 8, 26, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(515, 8, 28, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(516, 8, 29, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(517, 8, 30, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(518, 8, 31, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(519, 8, 32, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(520, 8, 33, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(521, 8, 34, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(522, 8, 35, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(523, 8, 67, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(524, 8, 68, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(525, 8, 37, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(526, 8, 38, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(527, 8, 66, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(528, 8, 40, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(529, 8, 41, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(530, 8, 42, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(531, 8, 43, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(532, 8, 44, 0, 0, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(533, 8, 45, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(534, 8, 47, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(535, 8, 48, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(536, 8, 69, 1, 1, 1, 1, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(537, 8, 50, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(538, 8, 51, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(539, 8, 52, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(540, 8, 53, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(541, 8, 54, 1, 1, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(542, 8, 56, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(543, 8, 57, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(544, 8, 58, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(545, 8, 59, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(546, 8, 60, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(547, 8, 61, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(548, 8, 62, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(549, 9, 1, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(550, 9, 2, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(551, 9, 3, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(552, 9, 4, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(553, 9, 5, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(554, 9, 6, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(555, 9, 7, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(556, 9, 8, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(557, 9, 64, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(558, 9, 65, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(559, 9, 63, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(560, 9, 10, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(561, 9, 11, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(562, 9, 12, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(563, 9, 14, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(564, 9, 15, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(565, 9, 16, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(566, 9, 17, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(567, 9, 18, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(568, 9, 19, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(569, 9, 20, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(570, 9, 21, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(571, 9, 23, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(572, 9, 24, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(573, 9, 25, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(574, 9, 26, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(575, 9, 28, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(576, 9, 29, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(577, 9, 30, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(578, 9, 31, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(579, 9, 32, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(580, 9, 33, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(581, 9, 34, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(582, 9, 35, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(583, 9, 67, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(584, 9, 68, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(585, 9, 37, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(586, 9, 38, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(587, 9, 66, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(588, 9, 40, 0, 0, 1, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(589, 9, 41, 0, 0, 1, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(590, 9, 42, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(591, 9, 43, 0, 0, 1, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(592, 9, 44, 0, 0, 1, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(593, 9, 45, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(594, 9, 47, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(595, 9, 48, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(596, 9, 69, 1, 1, 1, 1, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(597, 9, 50, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(598, 9, 51, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(599, 9, 52, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(600, 9, 53, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(601, 9, 54, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(602, 9, 56, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(603, 9, 57, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(604, 9, 58, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(605, 9, 59, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(606, 9, 60, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(607, 9, 61, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(608, 9, 62, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(609, 1, 70, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(610, 1, 71, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(611, 1, 72, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(612, 1, 73, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(613, 1, 74, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(614, 1, 75, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(615, 1, 76, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(616, 1, 77, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(617, 1, 78, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(618, 4, 70, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(619, 4, 71, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(620, 4, 72, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(621, 4, 73, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(622, 4, 74, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(623, 4, 77, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(624, 4, 75, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(625, 4, 76, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(626, 4, 78, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(1224, 7, 101, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1223, 7, 100, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1222, 7, 85, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1221, 7, 84, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1220, 7, 83, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1219, 7, 82, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0);
INSERT INTO `privileges` (`id`, `role_id`, `operation_id`, `is_add`, `is_edit`, `is_view`, `is_delete`, `status`, `created_at`, `modified_at`, `created_by`, `modified_by`) VALUES
(1218, 7, 81, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1217, 7, 79, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1216, 7, 106, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1215, 6, 128, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1214, 6, 127, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1213, 6, 126, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1212, 6, 125, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1211, 6, 124, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1210, 6, 123, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1209, 6, 122, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1208, 6, 121, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1207, 6, 120, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1206, 6, 119, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1205, 6, 118, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1204, 6, 117, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1203, 6, 116, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1202, 6, 115, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1201, 6, 114, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1200, 6, 113, 1, 1, 1, 1, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1199, 6, 112, 1, 1, 1, 1, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1198, 6, 111, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1197, 6, 107, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1196, 6, 104, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1195, 6, 99, 1, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1194, 6, 98, 1, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1193, 6, 97, 1, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1192, 6, 96, 1, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1191, 6, 133, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1190, 6, 132, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1189, 6, 131, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1188, 6, 130, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1187, 6, 129, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1186, 6, 109, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1185, 6, 95, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1184, 6, 94, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1183, 6, 93, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1182, 6, 92, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1181, 6, 91, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1180, 6, 90, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1179, 6, 89, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1178, 6, 88, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1177, 6, 134, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1176, 6, 110, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1175, 6, 87, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1174, 6, 86, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1173, 6, 102, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1172, 6, 108, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1171, 6, 135, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1170, 6, 105, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1169, 6, 103, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1168, 6, 101, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1167, 6, 100, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1166, 6, 85, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1165, 6, 84, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1164, 6, 83, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1163, 6, 82, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1162, 6, 81, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1161, 6, 79, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1160, 6, 106, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(1159, 5, 128, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1158, 5, 127, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1157, 5, 126, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1156, 5, 125, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(696, 3, 70, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(697, 3, 71, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(698, 3, 72, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(699, 3, 73, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(700, 3, 74, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(701, 3, 77, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(702, 3, 75, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(703, 3, 76, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(704, 3, 78, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(705, 9, 70, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(706, 9, 71, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(707, 9, 72, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(708, 9, 73, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(709, 9, 74, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(710, 9, 77, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(711, 9, 75, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(712, 9, 76, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(713, 9, 78, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(714, 8, 70, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(715, 8, 71, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(716, 8, 72, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(717, 8, 73, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(718, 8, 74, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(719, 8, 77, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(720, 8, 75, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(721, 8, 76, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(722, 8, 78, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(723, 7, 70, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(724, 7, 71, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(725, 7, 72, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(726, 7, 73, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(727, 7, 74, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(728, 7, 77, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(729, 7, 75, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(730, 7, 76, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(731, 7, 78, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(732, 6, 70, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(733, 6, 71, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(734, 6, 72, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(735, 6, 73, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(736, 6, 74, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(737, 6, 77, 0, 0, 0, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(738, 6, 75, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(739, 6, 76, 1, 1, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(740, 6, 78, 0, 0, 1, 0, 1, '2019-09-01 15:20:28', '0000-00-00 00:00:00', 1, 0),
(741, 2, 70, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(742, 2, 71, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(743, 2, 72, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(744, 2, 73, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(745, 2, 74, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(746, 2, 77, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(747, 2, 75, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(748, 2, 76, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(749, 2, 78, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(750, 13, 70, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(751, 13, 71, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(752, 13, 72, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(753, 13, 73, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(754, 13, 74, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(755, 13, 77, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(756, 13, 75, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(757, 13, 76, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(758, 13, 78, 0, 0, 0, 0, 1, '2018-04-16 07:42:13', '0000-00-00 00:00:00', 1, 0),
(759, 5, 70, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(760, 5, 71, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(761, 5, 72, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(762, 5, 73, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(763, 5, 74, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(764, 5, 77, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(765, 5, 75, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(766, 5, 76, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(767, 5, 78, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(768, 1, 79, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(769, 2, 79, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(770, 1, 80, 1, 1, 1, 1, 1, '2018-10-09 13:40:38', '0000-00-00 00:00:00', 1, 0),
(771, 1, 81, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(772, 1, 82, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(773, 2, 80, 0, 0, 0, 0, 1, '2018-10-09 16:08:37', '0000-00-00 00:00:00', 1, 0),
(774, 2, 81, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(775, 2, 82, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(776, 1, 83, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(777, 1, 84, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(778, 1, 85, 0, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(779, 1, 100, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(780, 1, 101, 0, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(781, 1, 103, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(782, 1, 102, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(783, 1, 86, 1, 0, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(784, 1, 87, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(785, 1, 88, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(786, 1, 89, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(787, 1, 90, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(788, 1, 91, 1, 1, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(789, 1, 92, 0, 0, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(790, 1, 93, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(791, 1, 94, 1, 0, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(792, 1, 95, 0, 0, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(793, 1, 96, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(794, 1, 97, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(795, 1, 98, 1, 0, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(796, 1, 99, 1, 0, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(797, 1, 104, 1, 1, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(798, 3, 79, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(799, 3, 81, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(800, 3, 82, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(801, 3, 83, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(802, 3, 84, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(803, 3, 85, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(804, 3, 100, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(805, 3, 101, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(806, 3, 103, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(807, 3, 102, 1, 1, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(808, 3, 86, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(809, 3, 87, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(810, 3, 88, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(811, 3, 89, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(812, 3, 90, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(813, 3, 91, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(814, 3, 92, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(815, 3, 93, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(816, 3, 94, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(817, 3, 95, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(818, 3, 96, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(819, 3, 97, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(820, 3, 98, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(821, 3, 99, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(822, 3, 104, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(823, 2, 83, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(824, 2, 84, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(825, 2, 85, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(826, 2, 100, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(827, 2, 101, 0, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(828, 2, 103, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(829, 2, 102, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(830, 2, 86, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(831, 2, 87, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(832, 2, 88, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(833, 2, 89, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(834, 2, 90, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(835, 2, 91, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(836, 2, 92, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(837, 2, 93, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(838, 2, 94, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(839, 2, 95, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(840, 2, 96, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(841, 2, 97, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(842, 2, 98, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(843, 2, 99, 1, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(844, 2, 104, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(845, 1, 106, 0, 0, 0, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(846, 1, 105, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(847, 2, 106, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(848, 2, 105, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(849, 2, 107, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(850, 1, 107, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(851, 1, 108, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(852, 1, 109, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(853, 1, 110, 0, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(854, 1, 111, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(855, 2, 108, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(856, 2, 110, 0, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(857, 2, 109, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(858, 2, 111, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(859, 2, 112, 1, 1, 1, 1, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(860, 1, 112, 0, 0, 0, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(861, 1, 113, 0, 0, 0, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(862, 1, 114, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(863, 1, 115, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(864, 2, 113, 1, 1, 1, 1, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(865, 2, 114, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(866, 2, 115, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(867, 1, 116, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(868, 1, 117, 0, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(869, 1, 118, 0, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(870, 1, 119, 0, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(871, 2, 116, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(872, 2, 117, 0, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(873, 2, 118, 0, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(874, 2, 119, 0, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(875, 1, 120, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(876, 1, 121, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(877, 1, 122, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(878, 1, 123, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(879, 1, 124, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(880, 1, 125, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(881, 1, 126, 0, 0, 1, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(882, 2, 120, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(883, 2, 121, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(884, 2, 122, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(885, 2, 123, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(886, 2, 124, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(887, 2, 125, 0, 0, 0, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(888, 2, 126, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(889, 2, 127, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(890, 2, 128, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(891, 1, 129, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(892, 1, 130, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(893, 1, 131, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(894, 1, 132, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(895, 1, 133, 1, 1, 1, 1, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(896, 1, 127, 0, 0, 0, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(897, 1, 128, 0, 0, 0, 0, 1, '2019-09-05 13:48:11', '0000-00-00 00:00:00', 1, 0),
(898, 3, 106, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(899, 3, 105, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(900, 3, 108, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(901, 3, 110, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(902, 3, 109, 0, 0, 1, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(903, 3, 129, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(904, 3, 130, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(905, 3, 131, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(906, 3, 132, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(907, 3, 133, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(908, 3, 107, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(909, 3, 111, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(910, 3, 112, 1, 1, 1, 1, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(911, 3, 113, 1, 1, 1, 1, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(912, 3, 114, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(913, 3, 115, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(914, 3, 116, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(915, 3, 117, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(916, 3, 118, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(917, 3, 119, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(918, 3, 120, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(919, 3, 121, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(920, 3, 122, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(921, 3, 123, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(922, 3, 124, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(923, 3, 125, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(924, 3, 126, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(925, 3, 127, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(926, 3, 128, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(927, 4, 106, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(928, 4, 79, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(929, 4, 81, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(930, 4, 82, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(931, 4, 83, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(932, 4, 84, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(933, 4, 85, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(934, 4, 100, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(935, 4, 101, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(936, 4, 103, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(937, 4, 105, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(938, 4, 108, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(939, 4, 102, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(940, 4, 86, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(941, 4, 87, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(942, 4, 110, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(943, 4, 88, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(944, 4, 89, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(945, 4, 90, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(946, 4, 91, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(947, 4, 92, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(948, 4, 93, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(949, 4, 94, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(950, 4, 95, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(951, 4, 109, 0, 0, 1, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(952, 4, 129, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(953, 4, 130, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(954, 4, 131, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(955, 4, 132, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(956, 4, 133, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(957, 4, 96, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(958, 4, 97, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(959, 4, 98, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(960, 4, 99, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(961, 4, 104, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(962, 4, 107, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(963, 4, 111, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(964, 4, 112, 1, 1, 1, 1, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(965, 4, 113, 1, 1, 1, 1, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(966, 4, 114, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(967, 4, 115, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(968, 4, 116, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(969, 4, 117, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(970, 4, 118, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(971, 4, 119, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(972, 4, 120, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(973, 4, 121, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(974, 4, 122, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(975, 4, 123, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(976, 4, 124, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(977, 4, 125, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(978, 4, 126, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(979, 4, 127, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(980, 4, 128, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(981, 9, 106, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(982, 9, 79, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(983, 9, 81, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(984, 9, 82, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(985, 9, 83, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(986, 9, 84, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(987, 9, 85, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(988, 9, 100, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(989, 9, 101, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(990, 9, 103, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(991, 9, 105, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(992, 9, 108, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(993, 9, 102, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(994, 9, 86, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(995, 9, 87, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(996, 9, 110, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(997, 9, 88, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(998, 9, 89, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(999, 9, 90, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1000, 9, 91, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1001, 9, 92, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1002, 9, 93, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1003, 9, 94, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1004, 9, 95, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1005, 9, 109, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1006, 9, 129, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1007, 9, 130, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1008, 9, 131, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1009, 9, 132, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1010, 9, 133, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1011, 9, 96, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1012, 9, 97, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1013, 9, 98, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1014, 9, 99, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1015, 9, 104, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1016, 9, 107, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1017, 9, 111, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1018, 9, 112, 1, 1, 1, 1, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1019, 9, 113, 1, 1, 1, 1, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1020, 9, 114, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1021, 9, 115, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1022, 9, 116, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1023, 9, 117, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1024, 9, 118, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1025, 9, 119, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1026, 9, 120, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1027, 9, 121, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1028, 9, 122, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1029, 9, 123, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1030, 9, 124, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1031, 9, 125, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1032, 9, 126, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1033, 9, 127, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1034, 9, 128, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1035, 1, 134, 1, 1, 1, 1, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(1036, 2, 134, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(1037, 2, 129, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(1038, 2, 130, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(1039, 2, 131, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(1040, 2, 132, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(1041, 2, 133, 1, 1, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(1042, 1, 135, 0, 0, 1, 0, 1, '2019-09-05 13:48:10', '0000-00-00 00:00:00', 1, 0),
(1043, 2, 135, 0, 0, 1, 0, 1, '2019-09-01 15:08:32', '0000-00-00 00:00:00', 1, 0),
(1155, 5, 124, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1154, 5, 123, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1153, 5, 122, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1152, 5, 121, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1151, 5, 120, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1150, 5, 119, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1149, 5, 118, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1148, 5, 117, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1147, 5, 116, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1146, 5, 115, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1145, 5, 114, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1144, 5, 113, 1, 1, 1, 1, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1143, 5, 112, 1, 1, 1, 1, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1142, 5, 111, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1141, 5, 107, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1140, 5, 104, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1139, 5, 99, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1138, 5, 98, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1137, 5, 97, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1136, 5, 96, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1135, 5, 133, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1134, 5, 132, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1133, 5, 131, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1132, 5, 130, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1131, 5, 129, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1130, 5, 109, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1129, 5, 95, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1128, 5, 94, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1127, 5, 93, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1126, 5, 92, 0, 0, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1125, 5, 91, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1124, 5, 90, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1123, 5, 89, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1122, 5, 88, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1121, 5, 134, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1120, 5, 110, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1119, 5, 87, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1118, 5, 86, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1117, 5, 102, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1116, 5, 108, 1, 1, 1, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1115, 5, 135, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1114, 5, 105, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1113, 5, 103, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1112, 5, 101, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1111, 5, 100, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1110, 5, 85, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1109, 5, 84, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1108, 5, 83, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1107, 5, 82, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1106, 5, 81, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1105, 5, 79, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1104, 5, 106, 0, 0, 0, 0, 1, '2019-09-01 15:18:23', '0000-00-00 00:00:00', 1, 0),
(1103, 4, 134, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(1102, 4, 135, 0, 0, 0, 0, 1, '2019-09-01 15:18:40', '0000-00-00 00:00:00', 1, 0),
(1101, 3, 134, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(1100, 3, 135, 0, 0, 0, 0, 1, '2019-09-01 15:18:53', '0000-00-00 00:00:00', 1, 0),
(1225, 7, 103, 0, 0, 0, 0, 1, '2019-09-01 15:21:12', '0000-00-00 00:00:00', 1, 0),
(1226, 7, 105, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1227, 7, 135, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1228, 7, 108, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1229, 7, 102, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1230, 7, 86, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1231, 7, 87, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1232, 7, 110, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1233, 7, 134, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1234, 7, 88, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1235, 7, 89, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1236, 7, 90, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1237, 7, 91, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1238, 7, 92, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1239, 7, 93, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1240, 7, 94, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1241, 7, 95, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1242, 7, 109, 1, 1, 1, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1243, 7, 129, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1244, 7, 130, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1245, 7, 131, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1246, 7, 132, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1247, 7, 133, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1248, 7, 96, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1249, 7, 97, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1250, 7, 98, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1251, 7, 99, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1252, 7, 104, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1253, 7, 107, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1254, 7, 111, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1255, 7, 112, 1, 1, 1, 1, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1256, 7, 113, 1, 1, 1, 1, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1257, 7, 114, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1258, 7, 115, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1259, 7, 116, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1260, 7, 117, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1261, 7, 118, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1262, 7, 119, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1263, 7, 120, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1264, 7, 121, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1265, 7, 122, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1266, 7, 123, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1267, 7, 124, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1268, 7, 125, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1269, 7, 126, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1270, 7, 127, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1271, 7, 128, 0, 0, 0, 0, 1, '2019-09-01 15:21:13', '0000-00-00 00:00:00', 1, 0),
(1272, 8, 106, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1273, 8, 79, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1274, 8, 81, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1275, 8, 82, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1276, 8, 83, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1277, 8, 84, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1278, 8, 85, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1279, 8, 100, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1280, 8, 101, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1281, 8, 103, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1282, 8, 105, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1283, 8, 135, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1284, 8, 108, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1285, 8, 102, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1286, 8, 86, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1287, 8, 87, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1288, 8, 110, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1289, 8, 134, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1290, 8, 88, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1291, 8, 89, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1292, 8, 90, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1293, 8, 91, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1294, 8, 92, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1295, 8, 93, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1296, 8, 94, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1297, 8, 95, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1298, 8, 109, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1299, 8, 129, 1, 1, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1300, 8, 130, 1, 1, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1301, 8, 131, 1, 1, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1302, 8, 132, 1, 1, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1303, 8, 133, 1, 1, 1, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1304, 8, 96, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1305, 8, 97, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1306, 8, 98, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1307, 8, 99, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1308, 8, 104, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1309, 8, 107, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1310, 8, 111, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1311, 8, 112, 1, 1, 1, 1, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1312, 8, 113, 1, 1, 1, 1, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1313, 8, 114, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1314, 8, 115, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1315, 8, 116, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1316, 8, 117, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1317, 8, 118, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1318, 8, 119, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1319, 8, 120, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1320, 8, 121, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1321, 8, 122, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1322, 8, 123, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1323, 8, 124, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1324, 8, 125, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1325, 8, 126, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1326, 8, 127, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1327, 8, 128, 0, 0, 0, 0, 1, '2019-09-01 15:22:38', '0000-00-00 00:00:00', 1, 0),
(1328, 9, 135, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1329, 9, 134, 0, 0, 0, 0, 1, '2019-09-01 15:23:13', '0000-00-00 00:00:00', 1, 0),
(1330, 14, 1, 0, 0, 1, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1331, 14, 2, 0, 0, 1, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1332, 14, 3, 0, 0, 1, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1333, 14, 106, 0, 0, 1, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1334, 14, 4, 0, 0, 1, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1335, 14, 5, 0, 0, 1, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1336, 14, 6, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1337, 14, 7, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1338, 14, 8, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1339, 14, 64, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1340, 14, 65, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1341, 14, 63, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1342, 14, 79, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1343, 14, 81, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1344, 14, 82, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1345, 14, 83, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1346, 14, 84, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1347, 14, 85, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1348, 14, 100, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1349, 14, 101, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1350, 14, 103, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1351, 14, 105, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1352, 14, 135, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1353, 14, 10, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1354, 14, 11, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1355, 14, 12, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1356, 14, 14, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1357, 14, 15, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1358, 14, 16, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1359, 14, 17, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1360, 14, 18, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1361, 14, 19, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1362, 14, 108, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1363, 14, 20, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1364, 14, 102, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1365, 14, 21, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1366, 14, 86, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1367, 14, 87, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1368, 14, 110, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1369, 14, 134, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1370, 14, 23, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1371, 14, 24, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1372, 14, 25, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1373, 14, 88, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1374, 14, 89, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1375, 14, 26, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1376, 14, 28, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1377, 14, 29, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1378, 14, 30, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0);
INSERT INTO `privileges` (`id`, `role_id`, `operation_id`, `is_add`, `is_edit`, `is_view`, `is_delete`, `status`, `created_at`, `modified_at`, `created_by`, `modified_by`) VALUES
(1379, 14, 31, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1380, 14, 32, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1381, 14, 33, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1382, 14, 34, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1383, 14, 35, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1384, 14, 67, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1385, 14, 68, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1386, 14, 90, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1387, 14, 91, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1388, 14, 92, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1389, 14, 93, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1390, 14, 94, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1391, 14, 95, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1392, 14, 37, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1393, 14, 38, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1394, 14, 66, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1395, 14, 109, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1396, 14, 40, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1397, 14, 41, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1398, 14, 42, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1399, 14, 43, 0, 0, 0, 0, 1, '2019-09-09 19:57:03', '0000-00-00 00:00:00', 1, 0),
(1400, 14, 44, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1401, 14, 45, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1402, 14, 47, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1403, 14, 48, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1404, 14, 69, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1405, 14, 50, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1406, 14, 51, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1407, 14, 52, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1408, 14, 53, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1409, 14, 54, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1410, 14, 129, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1411, 14, 130, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1412, 14, 131, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1413, 14, 132, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1414, 14, 133, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1415, 14, 56, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1416, 14, 57, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1417, 14, 58, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1418, 14, 59, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1419, 14, 60, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1420, 14, 61, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1421, 14, 96, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1422, 14, 97, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1423, 14, 98, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1424, 14, 99, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1425, 14, 62, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1426, 14, 70, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1427, 14, 71, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1428, 14, 72, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1429, 14, 73, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1430, 14, 74, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1431, 14, 77, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1432, 14, 104, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1433, 14, 75, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1434, 14, 76, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1435, 14, 78, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1436, 14, 107, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1437, 14, 111, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1438, 14, 112, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1439, 14, 113, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1440, 14, 114, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1441, 14, 115, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1442, 14, 116, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1443, 14, 117, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1444, 14, 118, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1445, 14, 119, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1446, 14, 120, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1447, 14, 121, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1448, 14, 122, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1449, 14, 123, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1450, 14, 124, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1451, 14, 125, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1452, 14, 126, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1453, 14, 127, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0),
(1454, 14, 128, 0, 0, 0, 0, 1, '2019-09-09 19:57:04', '0000-00-00 00:00:00', 1, 0);


ALTER TABLE `privileges`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`);

ALTER TABLE `privileges`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1455;
